/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.multithreading;

import java.util.Vector;
import net.imglib2.multithreading.Chunk;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleMultiThreading {
    public static Vector<Chunk> divideIntoChunks(long imageSize, int numThreads) {
        long threadChunkSize = imageSize / (long)numThreads;
        long threadChunkMod = imageSize % (long)numThreads;
        Vector<Chunk> chunks = new Vector<Chunk>();
        for (int threadID = 0; threadID < numThreads; ++threadID) {
            long startPosition = (long)threadID * threadChunkSize;
            long loopSize = threadID == numThreads - 1 ? threadChunkSize + threadChunkMod : threadChunkSize;
            chunks.add(new Chunk(startPosition, loopSize));
        }
        return chunks;
    }

    public static void startTask(Runnable run) {
        Thread[] threads = SimpleMultiThreading.newThreads();
        for (int ithread = 0; ithread < threads.length; ++ithread) {
            threads[ithread] = new Thread(run);
        }
        SimpleMultiThreading.startAndJoin(threads);
    }

    public static void startTask(Runnable run, int numThreads) {
        if (1 == numThreads) {
            run.run();
            return;
        }
        Thread[] threads = SimpleMultiThreading.newThreads(numThreads);
        for (int ithread = 0; ithread < threads.length; ++ithread) {
            threads[ithread] = new Thread(run);
        }
        SimpleMultiThreading.startAndJoin(threads);
    }

    public static Thread[] newThreads() {
        int nthread = Runtime.getRuntime().availableProcessors();
        return new Thread[nthread];
    }

    public static Thread[] newThreads(int numThreads) {
        return new Thread[numThreads];
    }

    public static void startAndJoin(Thread[] threads) {
        int ithread;
        if (1 == threads.length) {
            threads[0].run();
            return;
        }
        for (ithread = 0; ithread < threads.length; ++ithread) {
            threads[ithread].setPriority(5);
            threads[ithread].start();
        }
        try {
            for (ithread = 0; ithread < threads.length; ++ithread) {
                threads[ithread].join();
            }
        }
        catch (InterruptedException ie) {
            throw new RuntimeException(ie);
        }
    }

    public static void start(Thread[] threads) {
        for (int ithread = 0; ithread < threads.length; ++ithread) {
            threads[ithread].setPriority(1);
            threads[ithread].start();
        }
    }

    public static void threadHaltUnClean() {
        boolean i = false;
        while (!i) {
        }
    }

    public static void threadWait(long milliseconds) {
        try {
            Thread.sleep(milliseconds);
        }
        catch (InterruptedException e) {
            System.err.println("MultiThreading.threadWait(): Thread woken up: " + e);
        }
    }
}

