/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.meta;

import java.util.Hashtable;
import net.imglib2.meta.AxisType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Axes implements AxisType
{
    X("X"),
    Y("Y"),
    Z("Z"),
    TIME("Time"),
    CHANNEL("Channel"),
    SPECTRA("Spectra"),
    LIFETIME("Lifetime"),
    POLARIZATION("Polarization"),
    PHASE("Phase"),
    FREQUENCY("Frequency"),
    UNKNOWN("Unknown");

    private static Hashtable<String, AxisType> axes;
    private String label;

    public static synchronized AxisType get(String label) {
        AxisType axis = axes.get(label);
        if (axis == null) {
            axis = new CustomAxisType(label);
            axes.put(label, axis);
        }
        return axis;
    }

    public static boolean isXY(AxisType dimLabel) {
        return dimLabel == X || dimLabel == Y;
    }

    private Axes(String label) {
        this.label = label;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public boolean isXY() {
        return this == X || this == Y;
    }

    @Override
    public boolean isSpatial() {
        return this.isXY() || this == Z;
    }

    public String toString() {
        return this.label;
    }

    static {
        axes = new Hashtable();
        for (Axes axis : Axes.values()) {
            axes.put(axis.getLabel(), axis);
        }
    }

    public static class CustomAxisType
    implements AxisType {
        private final String label;

        public CustomAxisType(String label) {
            this.label = label;
        }

        public String getLabel() {
            return this.label;
        }

        public boolean isXY() {
            return false;
        }

        public boolean isSpatial() {
            return false;
        }

        public String toString() {
            return this.label;
        }
    }
}

