/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.labeling;

import java.util.Iterator;
import net.imglib2.Cursor;
import net.imglib2.Interval;
import net.imglib2.IterableRealInterval;
import net.imglib2.RandomAccess;
import net.imglib2.RealCursor;
import net.imglib2.converter.Converter;
import net.imglib2.converter.read.ConvertedCursor;
import net.imglib2.converter.read.ConvertedRandomAccess;
import net.imglib2.img.Img;
import net.imglib2.labeling.AbstractNativeLabeling;
import net.imglib2.labeling.DefaultROIStrategyFactory;
import net.imglib2.labeling.Labeling;
import net.imglib2.labeling.LabelingFactory;
import net.imglib2.labeling.LabelingMapping;
import net.imglib2.labeling.LabelingROIStrategyFactory;
import net.imglib2.labeling.LabelingType;
import net.imglib2.type.numeric.IntegerType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NativeImgLabeling<T extends Comparable<T>, I extends IntegerType<I>>
extends AbstractNativeLabeling<T> {
    protected final long[] generation;
    protected final Img<I> img;

    public NativeImgLabeling(Img<I> img) {
        super(NativeImgLabeling.dimensions(img), new DefaultROIStrategyFactory(), new LabelingMapping((IntegerType)((IntegerType)img.firstElement()).createVariable()));
        this.img = img;
        this.generation = new long[1];
    }

    private static long[] dimensions(Interval i) {
        long[] dims = new long[i.numDimensions()];
        i.dimensions(dims);
        return dims;
    }

    public NativeImgLabeling(LabelingROIStrategyFactory<T> strategyFactory, Img<I> img) {
        super(NativeImgLabeling.dimensions(img), strategyFactory, new LabelingMapping((IntegerType)((IntegerType)img.firstElement()).createVariable()));
        this.img = img;
        this.generation = new long[1];
    }

    @Override
    public RandomAccess<LabelingType<T>> randomAccess() {
        RandomAccess rndAccess = this.img.randomAccess();
        return new ConvertedRandomAccess(rndAccess, new LabelingTypeConverter(), new LabelingType((IntegerType)rndAccess.get(), this.mapping, this.generation));
    }

    @Override
    public Cursor<LabelingType<T>> cursor() {
        Cursor c = this.img.cursor();
        return new ConvertedCursor(c, new LabelingTypeConverter(), new LabelingType((IntegerType)c.get(), this.mapping, this.generation));
    }

    @Override
    public Cursor<LabelingType<T>> localizingCursor() {
        Cursor c = this.img.localizingCursor();
        return new ConvertedCursor(c, new LabelingTypeConverter(), new LabelingType((IntegerType)c.get(), this.mapping, this.generation));
    }

    public Img<I> getStorageImg() {
        return this.img;
    }

    @Override
    public Labeling<T> copy() {
        NativeImgLabeling<T, I> result = new NativeImgLabeling<T, I>(this.img.factory().create(this.img, ((IntegerType)this.img.firstElement()).createVariable()));
        RealCursor srcCursor = this.cursor();
        RealCursor resCursor = result.cursor();
        while (srcCursor.hasNext()) {
            srcCursor.fwd();
            resCursor.fwd();
            ((LabelingType)resCursor.get()).set((LabelingType)srcCursor.get());
        }
        return result;
    }

    @Override
    public boolean equalIterationOrder(IterableRealInterval<?> f) {
        return false;
    }

    @Override
    public LabelingType<T> firstElement() {
        return (LabelingType)this.cursor().next();
    }

    @Override
    public Iterator<LabelingType<T>> iterator() {
        return this.cursor();
    }

    @Override
    public RandomAccess<LabelingType<T>> randomAccess(Interval interval) {
        return this.randomAccess();
    }

    @Override
    public Object iterationOrder() {
        return this.img.iterationOrder();
    }

    @Override
    public <LL extends Comparable<LL>> LabelingFactory<LL> factory() {
        return new LabelingFactory<LL>(){

            @Override
            public Labeling<LL> create(long[] dim) {
                return new NativeImgLabeling(NativeImgLabeling.this.img.factory().create(dim, ((IntegerType)NativeImgLabeling.this.img.firstElement()).createVariable()));
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LabelingTypeConverter
    implements Converter<I, LabelingType<T>> {
        private LabelingTypeConverter() {
        }

        @Override
        public void convert(I input, LabelingType<T> output) {
        }
    }
}

