/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.labeling;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import net.imglib2.type.numeric.IntegerType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LabelingMapping<T extends Comparable<T>> {
    final List<T> theEmptyList;
    private final int maxNumLabels;
    protected Map<List<T>, InternedList<T>> internedLists = new HashMap<List<T>, InternedList<T>>();
    protected List<InternedList<T>> listsByIndex = new ArrayList<InternedList<T>>();

    public LabelingMapping(IntegerType<?> value) {
        this.maxNumLabels = (int)value.getMaxValue();
        List background = Collections.emptyList();
        this.theEmptyList = this.intern(background);
    }

    public List<T> emptyList() {
        return this.theEmptyList;
    }

    public synchronized List<T> intern(List<T> src) {
        return this.internImpl(src);
    }

    private InternedList<T> internImpl(List<T> src) {
        InternedList<T> interned;
        if (src instanceof InternedList) {
            interned = (InternedList<T>)src;
            if (interned.owner == this) {
                return interned;
            }
        }
        if (src.size() != 0) {
            ArrayList<T> copy = new ArrayList<T>(src);
            Collections.sort(copy);
            src = copy;
        }
        if ((interned = this.internedLists.get(src)) == null) {
            int intIndex = this.listsByIndex.size();
            if (intIndex > this.maxNumLabels) {
                throw new AssertionError((Object)String.format("Too many labels (or types of multiply-labeled pixels): %d maximum", intIndex));
            }
            interned = new InternedList<T>(src, intIndex, this);
            this.listsByIndex.add(interned);
            this.internedLists.put(src, interned);
        }
        return interned;
    }

    public List<T> intern(T[] src) {
        return this.intern(Arrays.asList(src));
    }

    public int indexOf(List<T> key) {
        InternedList<T> interned = this.internImpl(key);
        return interned.index;
    }

    public int indexOf(T[] key) {
        return this.indexOf(this.intern((Comparable[])key));
    }

    public final List<T> listAtIndex(int index) {
        return this.listsByIndex.get(index);
    }

    public int numLists() {
        return this.listsByIndex.size();
    }

    public List<T> getLabels() {
        HashSet<Comparable> result = new HashSet<Comparable>();
        for (InternedList<T> instance : this.listsByIndex) {
            for (Comparable label : instance) {
                result.add(label);
            }
        }
        return new ArrayList(result);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class InternedList<T1 extends Comparable<T1>>
    implements List<T1> {
        private final List<T1> value;
        final int index;
        final LabelingMapping<T1> owner;

        public InternedList(List<T1> src, int index, LabelingMapping<T1> owner) {
            this.owner = owner;
            this.value = Collections.unmodifiableList(src);
            this.index = index;
        }

        @Override
        public int size() {
            return this.value.size();
        }

        @Override
        public boolean isEmpty() {
            return this.value.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.value.contains(o);
        }

        @Override
        public Iterator<T1> iterator() {
            return this.value.iterator();
        }

        @Override
        public Object[] toArray() {
            return this.value.toArray();
        }

        @Override
        public boolean add(T1 e) {
            return this.value.add(e);
        }

        @Override
        public boolean remove(Object o) {
            return this.value.remove(o);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.value.containsAll(c);
        }

        @Override
        public boolean addAll(Collection<? extends T1> c) {
            return this.value.addAll(c);
        }

        @Override
        public boolean addAll(int index, Collection<? extends T1> c) {
            return this.value.addAll(index, c);
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            return this.value.removeAll(c);
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            return this.value.retainAll(c);
        }

        @Override
        public void clear() {
            this.value.clear();
        }

        @Override
        public T1 get(int index) {
            return (T1)((Comparable)this.value.get(index));
        }

        @Override
        public T1 set(int index, T1 element) {
            return (T1)((Comparable)this.value.set(index, element));
        }

        @Override
        public void add(int index, T1 element) {
            this.value.add(index, element);
        }

        @Override
        public T1 remove(int index) {
            return (T1)((Comparable)this.value.remove(index));
        }

        @Override
        public int indexOf(Object o) {
            return this.value.indexOf(o);
        }

        @Override
        public int lastIndexOf(Object o) {
            return this.value.lastIndexOf(o);
        }

        @Override
        public ListIterator<T1> listIterator() {
            return this.value.listIterator();
        }

        @Override
        public ListIterator<T1> listIterator(int index) {
            return this.value.listIterator(index);
        }

        @Override
        public List<T1> subList(int fromIndex, int toIndex) {
            return this.value.subList(fromIndex, toIndex);
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this.value.toArray(a);
        }

        @Override
        public int hashCode() {
            return ((Object)this.value).hashCode();
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof InternedList) {
                InternedList iobj = (InternedList)obj;
                return ((Object)this.value).equals(iobj.value);
            }
            return ((Object)this.value).equals(obj);
        }
    }
}

