/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.labeling;

import java.util.Arrays;

public class BoundingBox {
    protected long[] min;
    protected long[] max;

    public BoundingBox(int dimensions) {
        this.min = new long[dimensions];
        this.max = new long[dimensions];
        Arrays.fill(this.max, Integer.MIN_VALUE);
        Arrays.fill(this.min, Integer.MAX_VALUE);
    }

    public int getDimensions() {
        return this.min.length;
    }

    public void getExtents(long[] destMin, long[] destMax) {
        if (destMin != null) {
            System.arraycopy(this.min, 0, destMin, 0, this.min.length);
        }
        if (destMax != null) {
            System.arraycopy(this.max, 0, destMax, 0, this.max.length);
        }
    }

    public void update(long[] position) {
        for (int i = 0; i < this.min.length; ++i) {
            if (position[i] < this.min[i]) {
                this.min[i] = position[i];
            }
            if (position[i] <= this.max[i]) continue;
            this.max[i] = position[i];
        }
    }
}

