/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.iterator;

import net.imglib2.Interval;
import net.imglib2.iterator.IntervalIterator;
import net.imglib2.util.IntervalIndexer;
import net.imglib2.util.Util;

public class LocalizingIntervalIterator
extends IntervalIterator {
    protected final long[] position;

    public LocalizingIntervalIterator(long[] dimensions) {
        super(dimensions);
        this.position = new long[this.n];
        this.reset();
    }

    public LocalizingIntervalIterator(int[] dimensions) {
        this(Util.int2long(dimensions));
    }

    public LocalizingIntervalIterator(long[] min, long[] max) {
        super(min, max);
        this.position = new long[this.n];
        this.reset();
    }

    public LocalizingIntervalIterator(int[] min, int[] max) {
        this(Util.int2long(min), Util.int2long(max));
    }

    public LocalizingIntervalIterator(Interval interval) {
        super(interval);
        this.position = new long[this.n];
        this.reset();
    }

    public void fwd() {
        ++this.index;
        for (int d = 0; d < this.n; ++d) {
            int n = d;
            this.position[n] = this.position[n] + 1L;
            if (this.position[n] <= this.max[d]) break;
            this.position[d] = this.min[d];
        }
    }

    public void jumpFwd(long i) {
        this.index += i;
        IntervalIndexer.indexToPositionWithOffset(this.index, this.dimensions, this.min, this.position);
    }

    public void reset() {
        this.index = -1L;
        this.position[0] = this.min[0] - 1L;
        for (int d = 1; d < this.n; ++d) {
            this.position[d] = this.min[d];
        }
    }

    public void localize(float[] pos) {
        for (int d = 0; d < this.n; ++d) {
            pos[d] = this.position[d];
        }
    }

    public void localize(double[] pos) {
        for (int d = 0; d < this.n; ++d) {
            pos[d] = this.position[d];
        }
    }

    public void localize(int[] pos) {
        for (int d = 0; d < this.n; ++d) {
            pos[d] = (int)this.position[d];
        }
    }

    public void localize(long[] pos) {
        for (int d = 0; d < this.n; ++d) {
            pos[d] = this.position[d];
        }
    }

    public float getFloatPosition(int d) {
        return this.position[d];
    }

    public double getDoublePosition(int d) {
        return this.position[d];
    }

    public int getIntPosition(int d) {
        return (int)this.position[d];
    }

    public long getLongPosition(int d) {
        return this.position[d];
    }
}

