/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.interpolation.randomaccess;

import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessible;
import net.imglib2.interpolation.randomaccess.NLinearInterpolator;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.NumericType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NLinearInterpolator2D<T extends NumericType<T>>
extends NLinearInterpolator<T> {
    protected NLinearInterpolator2D(NLinearInterpolator2D<T> interpolator) {
        super(interpolator);
    }

    protected NLinearInterpolator2D(RandomAccessible<T> randomAccessible, T type) {
        super(randomAccessible, type);
    }

    protected NLinearInterpolator2D(RandomAccessible<T> randomAccessible) {
        super(randomAccessible);
    }

    @Override
    public final int numDimensions() {
        return 2;
    }

    @Override
    protected void fillWeights() {
        double w0 = this.position[0] - (double)((RandomAccess)this.target).getLongPosition(0);
        double w0Inv = 1.0 - w0;
        double w1 = this.position[1] - (double)((RandomAccess)this.target).getLongPosition(1);
        double w1Inv = 1.0 - w1;
        this.weights[0] = w0Inv * w1Inv;
        this.weights[1] = w0 * w1Inv;
        this.weights[2] = w0Inv * w1;
        this.weights[3] = w0 * w1;
    }

    @Override
    public T get() {
        this.fillWeights();
        this.accumulator.set((Type)((RandomAccess)this.target).get());
        this.accumulator.mul(this.weights[0]);
        ((RandomAccess)this.target).fwd(0);
        this.tmp.set((Type)((RandomAccess)this.target).get());
        this.tmp.mul(this.weights[1]);
        this.accumulator.add(this.tmp);
        ((RandomAccess)this.target).fwd(1);
        this.tmp.set((Type)((RandomAccess)this.target).get());
        this.tmp.mul(this.weights[3]);
        this.accumulator.add(this.tmp);
        ((RandomAccess)this.target).bck(0);
        this.tmp.set((Type)((RandomAccess)this.target).get());
        this.tmp.mul(this.weights[2]);
        this.accumulator.add(this.tmp);
        ((RandomAccess)this.target).bck(1);
        return (T)this.accumulator;
    }

    @Override
    public NLinearInterpolator2D<T> copy() {
        return new NLinearInterpolator2D<T>(this);
    }
}

