/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.interpolation.randomaccess;

import net.imglib2.RandomAccessible;
import net.imglib2.RealInterval;
import net.imglib2.interpolation.InterpolatorFactory;
import net.imglib2.interpolation.randomaccess.LanczosInterpolator;
import net.imglib2.type.numeric.RealType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LanczosInterpolatorFactory<T extends RealType<T>>
implements InterpolatorFactory<T, RandomAccessible<T>> {
    int alpha;
    boolean clipping;
    double min;
    double max;

    public LanczosInterpolatorFactory(int alpha, boolean clipping) {
        this.alpha = alpha;
        this.clipping = clipping;
        this.max = 0.0;
        this.min = 0.0;
    }

    public LanczosInterpolatorFactory(int alpha, double min, double max) {
        this.alpha = alpha;
        this.clipping = true;
        this.min = min;
        this.max = max;
    }

    public LanczosInterpolatorFactory(double min, double max) {
        this.alpha = 3;
        this.clipping = true;
        this.min = min;
        this.max = max;
    }

    public LanczosInterpolatorFactory() {
        this(3, true);
    }

    @Override
    public LanczosInterpolator<T> create(RandomAccessible<T> randomAccessible) {
        return new LanczosInterpolator<T>(randomAccessible, this.alpha, this.clipping, this.min, this.max);
    }

    @Override
    public LanczosInterpolator<T> create(RandomAccessible<T> randomAccessible, RealInterval interval) {
        return this.create(randomAccessible);
    }

    public void setAlpha(int alpha) {
        this.alpha = alpha;
    }

    public void setClipping(boolean clipping) {
        this.clipping = clipping;
    }

    public int getAlpha() {
        return this.alpha;
    }

    public boolean getClipping() {
        return this.clipping;
    }
}

