/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.interpolation.randomaccess;

import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessible;
import net.imglib2.RealRandomAccess;
import net.imglib2.Sampler;
import net.imglib2.position.transform.FloorOffset;
import net.imglib2.type.numeric.RealType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LanczosInterpolator<T extends RealType<T>>
extends FloorOffset<RandomAccess<T>>
implements RealRandomAccess<T> {
    protected static final double piSquare = Math.PI * Math.PI;
    protected static final int lutScale = 10;
    protected final int alpha;
    protected final T interpolatedValue;
    protected final long[] size;
    protected final long[] max;
    protected final double minValue;
    protected final double maxValue;
    protected final boolean clip;
    protected final double[] lut;
    protected final double[] products;

    private static final long[] createOffset(int a, int n) {
        long[] offset = new long[n];
        for (int d = 0; d < n; ++d) {
            offset[d] = -a + 1;
        }
        return offset;
    }

    public LanczosInterpolator(RandomAccessible<T> randomAccessible, int alpha, boolean clip, double min, double max) {
        super(randomAccessible.randomAccess(), LanczosInterpolator.createOffset(alpha, randomAccessible.numDimensions()));
        this.alpha = alpha;
        this.lut = LanczosInterpolator.createLanczosLUT(alpha, 10);
        this.products = new double[this.n + 1];
        this.products[this.n] = 1.0;
        this.size = new long[this.n];
        this.max = new long[this.n];
        for (int d = 0; d < this.n; ++d) {
            this.size[d] = alpha * 2;
        }
        this.clip = clip;
        this.interpolatedValue = (RealType)((RealType)((RandomAccess)this.target).get()).createVariable();
        if (min == max) {
            this.minValue = this.interpolatedValue.getMinValue();
            this.maxValue = this.interpolatedValue.getMaxValue();
        } else {
            this.minValue = min;
            this.maxValue = max;
        }
    }

    public LanczosInterpolator(LanczosInterpolator<T> interpolator) {
        super(((RandomAccess)interpolator.target).copyRandomAccess(), interpolator.offset);
        this.alpha = interpolator.alpha;
        this.lut = (double[])interpolator.lut.clone();
        this.products = (double[])interpolator.products.clone();
        this.size = (long[])interpolator.size.clone();
        this.max = (long[])interpolator.max.clone();
        this.clip = interpolator.clip;
        this.interpolatedValue = (RealType)interpolator.interpolatedValue.copy();
        this.minValue = interpolator.minValue;
        this.maxValue = interpolator.maxValue;
    }

    private static final double[] createLanczosLUT(int max, int scale) {
        double[] lut = new double[max * scale + 2];
        for (int i = 0; i < lut.length; ++i) {
            double x = (double)i / 10.0;
            lut[i] = LanczosInterpolator.lanczos(x, max);
        }
        return lut;
    }

    protected final void resetKernel() {
        for (int d = this.n - 1; d >= 0; --d) {
            long p = ((RandomAccess)this.target).getLongPosition(d);
            this.max[d] = p + this.size[d];
            this.products[d] = this.lookUpLanczos(this.position[d] - (double)p) * this.products[d + 1];
        }
    }

    protected final void accumulate(int d) {
        for (int e = d; e >= 0; --e) {
            this.products[e] = this.lookUpLanczos(this.position[e] - (double)((RandomAccess)this.target).getLongPosition(e)) * this.products[e + 1];
        }
    }

    @Override
    public T get() {
        double convolved = 0.0;
        this.resetKernel();
        boolean proceed = true;
        block0: while (proceed) {
            convolved += ((RealType)((RandomAccess)this.target).get()).getRealDouble() * this.products[0];
            for (int d = 0; d < this.n; ++d) {
                ((RandomAccess)this.target).fwd(d);
                long p = ((RandomAccess)this.target).getLongPosition(d);
                if (p < this.max[d]) {
                    this.products[d] = this.lookUpLanczos(this.position[d] - (double)p) * this.products[++d];
                    continue block0;
                }
                ((RandomAccess)this.target).move(-this.size[d], d);
                this.accumulate(d);
            }
            proceed = false;
        }
        if (this.clip) {
            if (convolved < this.minValue) {
                convolved = this.minValue;
            } else if (convolved > this.maxValue) {
                convolved = this.maxValue;
            }
        }
        this.interpolatedValue.setReal(convolved);
        return this.interpolatedValue;
    }

    private static final double lanczos(double x, double a) {
        if (x == 0.0) {
            return 1.0;
        }
        return a * Math.sin(Math.PI * x) * Math.sin(Math.PI * x / a) / (Math.PI * Math.PI * x * x);
    }

    private final double lookUpLanczos(double x) {
        double y = x < 0.0 ? -10.0 * x : 10.0 * x;
        int yi = (int)y;
        double d = y - (double)yi;
        return (this.lut[yi + 1] - this.lut[yi]) * d + this.lut[yi];
    }

    @Override
    public Sampler<T> copy() {
        return this.copy();
    }

    @Override
    public RealRandomAccess<T> copyRealRandomAccess() {
        return new LanczosInterpolator<T>(this);
    }
}

