/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.img.transform;

import java.util.Iterator;
import net.imglib2.Cursor;
import net.imglib2.Interval;
import net.imglib2.IterableRealInterval;
import net.imglib2.Localizable;
import net.imglib2.Point;
import net.imglib2.Positionable;
import net.imglib2.RandomAccess;
import net.imglib2.RealPositionable;
import net.imglib2.Sampler;
import net.imglib2.img.Img;
import net.imglib2.img.ImgFactory;
import net.imglib2.transform.integer.TranslationTransform;
import net.imglib2.type.Type;
import net.imglib2.view.TransformView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImgTranslationAdapter<T extends Type<T>, I extends Img<T>>
extends Point
implements Img<T> {
    protected final I img;

    public ImgTranslationAdapter(I img) {
        super(img.numDimensions());
        this.img = img;
    }

    public ImgTranslationAdapter(I img, long[] offset) {
        super(offset);
        this.img = img;
    }

    public ImgTranslationAdapter(I img, Localizable localizable) {
        super(localizable);
        this.img = img;
    }

    @Override
    public RandomAccess<T> randomAccess() {
        return new TransformView(this.img, this.getTranslationTransform()).randomAccess();
    }

    @Override
    public RandomAccess<T> randomAccess(Interval interval) {
        return new TransformView(this.img, this.getTranslationTransform()).randomAccess(interval);
    }

    protected TranslationTransform getTranslationTransform() {
        long[] translation = new long[this.numDimensions()];
        for (int i = 0; i < this.numDimensions(); ++i) {
            translation[i] = -this.position[i];
        }
        return new TranslationTransform(translation);
    }

    @Override
    public long min(int d) {
        return this.img.min(d) + this.position[d];
    }

    @Override
    public void min(long[] min) {
        this.img.min(min);
        for (int i = 0; i < this.numDimensions(); ++i) {
            int n = i;
            min[n] = min[n] + this.position[i];
        }
    }

    @Override
    public void min(Positionable min) {
        this.img.min(min);
        min.move(this);
    }

    @Override
    public long max(int d) {
        return this.img.max(d) + this.position[d];
    }

    @Override
    public void max(long[] max) {
        this.img.max(max);
        for (int i = 0; i < this.numDimensions(); ++i) {
            int n = i;
            max[n] = max[n] + this.position[i];
        }
    }

    @Override
    public void max(Positionable max) {
        this.img.max(max);
        max.move(this);
    }

    @Override
    public void dimensions(long[] dimensions) {
        this.img.dimensions(dimensions);
    }

    @Override
    public long dimension(int d) {
        return this.img.dimension(d);
    }

    @Override
    public double realMin(int d) {
        return this.img.realMin(d) + (double)this.position[d];
    }

    @Override
    public void realMin(double[] min) {
        this.img.realMin(min);
        for (int i = 0; i < this.numDimensions(); ++i) {
            int n = i;
            min[n] = min[n] + (double)this.position[i];
        }
    }

    @Override
    public void realMin(RealPositionable min) {
        this.img.realMin(min);
        min.move(this);
    }

    @Override
    public double realMax(int d) {
        return this.img.realMax(d) + (double)this.position[d];
    }

    @Override
    public void realMax(double[] max) {
        this.img.realMax(max);
        for (int i = 0; i < this.numDimensions(); ++i) {
            int n = i;
            max[n] = max[n] + (double)this.position[i];
        }
    }

    @Override
    public void realMax(RealPositionable max) {
        this.img.realMax(max);
        max.move(this);
    }

    @Override
    public Cursor<T> cursor() {
        return this.cursorImpl(this.img.cursor());
    }

    @Override
    public Cursor<T> localizingCursor() {
        return this.cursorImpl(this.img.localizingCursor());
    }

    private Cursor<T> cursorImpl(final Cursor<T> c) {
        final long[] offset = (long[])this.position.clone();
        return new Cursor<T>(){

            @Override
            public void localize(float[] pos) {
                c.localize(pos);
                for (int i = 0; i < this.numDimensions(); ++i) {
                    int n = i;
                    pos[n] = pos[n] + (float)offset[i];
                }
            }

            @Override
            public void localize(double[] pos) {
                c.localize(pos);
                for (int i = 0; i < this.numDimensions(); ++i) {
                    int n = i;
                    pos[n] = pos[n] + (double)offset[i];
                }
            }

            @Override
            public float getFloatPosition(int d) {
                return c.getFloatPosition(d) + (float)offset[d];
            }

            @Override
            public double getDoublePosition(int d) {
                return c.getDoublePosition(d) + (double)offset[d];
            }

            @Override
            public int numDimensions() {
                return ImgTranslationAdapter.this.numDimensions();
            }

            @Override
            public T get() {
                return (Type)c.get();
            }

            @Override
            public Sampler<T> copy() {
                return this.copyCursor();
            }

            @Override
            public void jumpFwd(long steps) {
                c.jumpFwd(steps);
            }

            @Override
            public void fwd() {
                c.fwd();
            }

            @Override
            public void reset() {
                c.reset();
            }

            @Override
            public boolean hasNext() {
                return c.hasNext();
            }

            @Override
            public T next() {
                return (Type)c.next();
            }

            @Override
            public void remove() {
                c.remove();
            }

            @Override
            public void localize(int[] pos) {
                c.localize(pos);
                for (int i = 0; i < this.numDimensions(); ++i) {
                    int n = i;
                    pos[n] = (int)((long)pos[n] + offset[i]);
                }
            }

            @Override
            public void localize(long[] pos) {
                c.localize(pos);
                for (int i = 0; i < this.numDimensions(); ++i) {
                    int n = i;
                    pos[n] = pos[n] + offset[i];
                }
            }

            @Override
            public int getIntPosition(int d) {
                return c.getIntPosition(d) + (int)offset[d];
            }

            @Override
            public long getLongPosition(int d) {
                return (long)c.getIntPosition(d) + offset[d];
            }

            @Override
            public Cursor<T> copyCursor() {
                return ImgTranslationAdapter.this.cursorImpl(c.copyCursor());
            }
        };
    }

    @Override
    public long size() {
        return this.img.size();
    }

    @Override
    public T firstElement() {
        return (T)((Type)this.img.firstElement());
    }

    @Override
    public Object iterationOrder() {
        return this.img.iterationOrder();
    }

    @Override
    public boolean equalIterationOrder(IterableRealInterval<?> f) {
        return this.iterationOrder().equals(f.iterationOrder());
    }

    @Override
    public Iterator<T> iterator() {
        return this.cursorImpl(this.img.cursor());
    }

    @Override
    public ImgFactory<T> factory() {
        return this.img.factory();
    }

    public ImgTranslationAdapter<T, I> copy() {
        return new ImgTranslationAdapter<T, I>(this.img, this);
    }
}

