/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.img.sparse;

import net.imglib2.exception.IncompatibleTypeException;
import net.imglib2.img.ImgFactory;
import net.imglib2.img.NativeImgFactory;
import net.imglib2.img.sparse.BooleanNtree;
import net.imglib2.img.sparse.ByteNtree;
import net.imglib2.img.sparse.CharNtree;
import net.imglib2.img.sparse.DoubleNtree;
import net.imglib2.img.sparse.FloatNtree;
import net.imglib2.img.sparse.IntNtree;
import net.imglib2.img.sparse.LongNtree;
import net.imglib2.img.sparse.NtreeImg;
import net.imglib2.img.sparse.ShortNtree;
import net.imglib2.type.NativeType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NtreeImgFactory<T extends NativeType<T>>
extends NativeImgFactory<T> {
    @Override
    public NtreeImg<T, ?> create(long[] dim, T type) {
        return (NtreeImg)type.createSuitableNativeImg(this, dim);
    }

    @Override
    public NtreeImg<T, BooleanNtree> createBitInstance(long[] dimensions, int entitiesPerPixel) {
        if (entitiesPerPixel != 1) {
            throw new RuntimeException("not implemented");
        }
        return new NtreeImg(new BooleanNtree(dimensions, new long[dimensions.length], false), dimensions, 1);
    }

    @Override
    public NtreeImg<T, ByteNtree> createByteInstance(long[] dimensions, int entitiesPerPixel) {
        if (entitiesPerPixel != 1) {
            throw new RuntimeException("not implemented");
        }
        return new NtreeImg(new ByteNtree(dimensions, new long[dimensions.length], (byte)0), dimensions, 1);
    }

    @Override
    public NtreeImg<T, CharNtree> createCharInstance(long[] dimensions, int entitiesPerPixel) {
        if (entitiesPerPixel != 1) {
            throw new RuntimeException("not implemented");
        }
        return new NtreeImg(new CharNtree(dimensions, new long[dimensions.length], Character.valueOf('\u0000')), dimensions, 1);
    }

    @Override
    public NtreeImg<T, ShortNtree> createShortInstance(long[] dimensions, int entitiesPerPixel) {
        if (entitiesPerPixel != 1) {
            throw new RuntimeException("not implemented");
        }
        return new NtreeImg(new ShortNtree(dimensions, new long[dimensions.length], 0), dimensions, 1);
    }

    @Override
    public NtreeImg<T, IntNtree> createIntInstance(long[] dimensions, int entitiesPerPixel) {
        if (entitiesPerPixel != 1) {
            throw new RuntimeException("not implemented");
        }
        return new NtreeImg(new IntNtree(dimensions, new long[dimensions.length], 0), dimensions, 1);
    }

    @Override
    public NtreeImg<T, LongNtree> createLongInstance(long[] dimensions, int entitiesPerPixel) {
        if (entitiesPerPixel != 1) {
            throw new RuntimeException("not implemented");
        }
        return new NtreeImg(new LongNtree(dimensions, new long[dimensions.length], 0L), dimensions, 1);
    }

    @Override
    public NtreeImg<T, FloatNtree> createFloatInstance(long[] dimensions, int entitiesPerPixel) {
        if (entitiesPerPixel != 1) {
            throw new RuntimeException("not implemented");
        }
        return new NtreeImg(new FloatNtree(dimensions, new long[dimensions.length], Float.valueOf(0.0f)), dimensions, 1);
    }

    @Override
    public NtreeImg<T, DoubleNtree> createDoubleInstance(long[] dimensions, int entitiesPerPixel) {
        if (entitiesPerPixel != 1) {
            throw new RuntimeException("not implemented");
        }
        return new NtreeImg(new DoubleNtree(dimensions, new long[dimensions.length], 0.0), dimensions, 1);
    }

    @Override
    public <S> ImgFactory<S> imgFactory(S type) throws IncompatibleTypeException {
        if (NativeType.class.isInstance(type)) {
            return new NtreeImgFactory<T>();
        }
        throw new IncompatibleTypeException(this, type.getClass().getCanonicalName() + " does not implement NativeType.");
    }
}

