/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.img.planar;

import net.imglib2.AbstractLocalizingCursorInt;
import net.imglib2.img.planar.PlanarImg;
import net.imglib2.type.NativeType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlanarLocalizingCursor<T extends NativeType<T>>
extends AbstractLocalizingCursorInt<T>
implements PlanarImg.PlanarContainerSampler {
    protected final T type;
    protected final PlanarImg<T, ?> container;
    protected final int lastIndex;
    protected final int lastSliceIndex;
    protected int sliceIndex;
    protected int index;
    protected final int[] max;

    protected PlanarLocalizingCursor(PlanarLocalizingCursor<T> cursor) {
        super(cursor.numDimensions());
        this.container = cursor.container;
        this.type = this.container.createLinkedType();
        this.lastIndex = cursor.lastIndex;
        this.lastSliceIndex = cursor.lastSliceIndex;
        this.max = new int[this.n];
        for (int d = 0; d < this.n; ++d) {
            this.max[d] = cursor.max[d];
            this.position[d] = cursor.position[d];
        }
        this.sliceIndex = cursor.sliceIndex;
        this.index = cursor.index;
        this.type.updateContainer(this);
        this.type.updateIndex(this.index);
    }

    public PlanarLocalizingCursor(PlanarImg<T, ?> container) {
        super(container.numDimensions());
        this.type = container.createLinkedType();
        this.container = container;
        this.lastIndex = (this.n > 1 ? container.dimensions[1] : 1) * container.dimensions[0] - 1;
        this.lastSliceIndex = container.numSlices() - 1;
        this.max = new int[this.n];
        for (int d = 0; d < this.n; ++d) {
            this.max[d] = (int)container.max(d);
        }
        this.reset();
    }

    @Override
    public int getCurrentSliceIndex() {
        return this.sliceIndex;
    }

    @Override
    public T get() {
        return this.type;
    }

    @Override
    public PlanarLocalizingCursor<T> copy() {
        return new PlanarLocalizingCursor<T>(this);
    }

    @Override
    public PlanarLocalizingCursor<T> copyCursor() {
        return this.copy();
    }

    @Override
    public boolean hasNext() {
        return this.sliceIndex < this.lastSliceIndex || this.index < this.lastIndex;
    }

    @Override
    public void fwd() {
        if (++this.index > this.lastIndex) {
            this.index = 0;
            ++this.sliceIndex;
            this.type.updateContainer(this);
        }
        this.type.updateIndex(this.index);
        for (int d = 0; d < this.n; ++d) {
            int n = d;
            this.position[n] = this.position[n] + 1;
            if (this.position[n] <= this.max[d]) break;
            this.position[d] = 0;
        }
    }

    @Override
    public void jumpFwd(long steps) {
        long newIndex = (long)this.index + steps;
        if (newIndex > (long)this.lastIndex) {
            long s = newIndex / (long)(this.lastIndex + 1);
            newIndex -= s * (long)(this.lastIndex + 1);
            this.sliceIndex = (int)((long)this.sliceIndex + s);
            this.type.updateContainer(this);
        }
        this.index = (int)newIndex;
        this.type.updateIndex(this.index);
        this.container.indexToGlobalPosition(this.sliceIndex, this.index, this.position);
    }

    @Override
    public void reset() {
        this.position[0] = -1;
        for (int d = 1; d < this.n; ++d) {
            this.position[d] = 0;
        }
        this.sliceIndex = 0;
        this.index = -1;
        this.type.updateIndex(-1);
        this.type.updateContainer(this);
    }
}

