/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.img.planar;

import java.util.ArrayList;
import net.imglib2.AbstractCursorInt;
import net.imglib2.Cursor;
import net.imglib2.FlatIterationOrder;
import net.imglib2.img.AbstractNativeImg;
import net.imglib2.img.NativeImg;
import net.imglib2.img.basictypeaccess.PlanarAccess;
import net.imglib2.img.basictypeaccess.array.ArrayDataAccess;
import net.imglib2.img.planar.PlanarCursor;
import net.imglib2.img.planar.PlanarCursor1D;
import net.imglib2.img.planar.PlanarCursor2D;
import net.imglib2.img.planar.PlanarImgFactory;
import net.imglib2.img.planar.PlanarLocalizingCursor;
import net.imglib2.img.planar.PlanarLocalizingCursor1D;
import net.imglib2.img.planar.PlanarLocalizingCursor2D;
import net.imglib2.img.planar.PlanarRandomAccess;
import net.imglib2.img.planar.PlanarRandomAccess1D;
import net.imglib2.type.NativeType;
import net.imglib2.type.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlanarImg<T extends NativeType<T>, A extends ArrayDataAccess<A>>
extends AbstractNativeImg<T, A>
implements PlanarAccess<A> {
    protected final int numSlices;
    protected final int[] dimensions;
    protected final int[] sliceSteps;
    protected final ArrayList<A> mirror;

    public PlanarImg(long[] dim, int entitiesPerPixel) {
        this(null, dim, entitiesPerPixel);
    }

    PlanarImg(A creator, long[] dim, int entitiesPerPixel) {
        super(dim, entitiesPerPixel);
        this.dimensions = new int[this.n];
        for (int d = 0; d < this.n; ++d) {
            this.dimensions[d] = (int)dim[d];
        }
        if (this.n > 2) {
            this.sliceSteps = new int[this.n];
            this.sliceSteps[2] = 1;
            for (int i = 3; i < this.n; ++i) {
                int j = i - 1;
                this.sliceSteps[i] = this.dimensions[j] * this.sliceSteps[j];
            }
        } else {
            this.sliceSteps = null;
        }
        int s = 1;
        for (int d = 2; d < this.n; ++d) {
            s *= this.dimensions[d];
        }
        this.numSlices = s;
        this.mirror = new ArrayList(this.numSlices);
        if (creator == null) {
            for (int i = 0; i < this.numSlices; ++i) {
                this.mirror.add(null);
            }
        } else {
            int entitiesPerSlice = (this.n > 1 ? this.dimensions[1] : 1) * this.dimensions[0] * entitiesPerPixel;
            for (int i = 0; i < this.numSlices; ++i) {
                this.mirror.add(creator.createArray(entitiesPerSlice));
            }
        }
    }

    @Override
    public A update(Object c) {
        int i = ((PlanarContainerSampler)c).getCurrentSliceIndex();
        return (A)((ArrayDataAccess)this.mirror.get(i < 0 ? 0 : (i >= this.numSlices ? this.numSlices - 1 : i)));
    }

    public int numSlices() {
        return this.numSlices;
    }

    public final int getIndex(int[] l) {
        if (this.n > 1) {
            return l[1] * this.dimensions[0] + l[0];
        }
        return l[0];
    }

    public void indexToGlobalPosition(int sliceIndex, int indexInSlice, int[] position) {
        if (this.n > 1) {
            position[1] = indexInSlice / this.dimensions[0];
            position[0] = indexInSlice - position[1] * this.dimensions[0];
            if (this.n > 2) {
                int maxDim = this.n - 1;
                for (int d = 2; d < maxDim; ++d) {
                    int j = sliceIndex / this.dimensions[d];
                    position[d] = sliceIndex - j * this.dimensions[d];
                    sliceIndex = j;
                }
                position[maxDim] = sliceIndex;
            }
        } else {
            position[0] = indexInSlice;
        }
    }

    public int indexToGlobalPosition(int sliceIndex, int indexInSlice, int dim) {
        if (dim == 0) {
            return indexInSlice % this.dimensions[0];
        }
        if (dim == 1) {
            return indexInSlice / this.dimensions[0];
        }
        if (dim < this.n) {
            return sliceIndex / this.sliceSteps[dim] % this.dimensions[dim];
        }
        return 0;
    }

    @Override
    public PlanarCursor<T> cursor() {
        if (this.n == 1) {
            return new PlanarCursor1D(this);
        }
        if (this.n == 2) {
            return new PlanarCursor2D(this);
        }
        return new PlanarCursor(this);
    }

    @Override
    public PlanarLocalizingCursor<T> localizingCursor() {
        if (this.n == 1) {
            return new PlanarLocalizingCursor1D(this);
        }
        if (this.n == 2) {
            return new PlanarLocalizingCursor2D(this);
        }
        return new PlanarLocalizingCursor(this);
    }

    @Override
    public PlanarRandomAccess<T> randomAccess() {
        if (this.n == 1) {
            return new PlanarRandomAccess1D(this);
        }
        return new PlanarRandomAccess(this);
    }

    @Override
    public FlatIterationOrder iterationOrder() {
        return new FlatIterationOrder(this);
    }

    @Override
    public A getPlane(int no) {
        return (A)((ArrayDataAccess)this.mirror.get(no));
    }

    @Override
    public void setPlane(int no, A plane) {
        this.mirror.set(no, plane);
    }

    @Override
    public PlanarImgFactory<T> factory() {
        return new PlanarImgFactory();
    }

    public PlanarImg<T, ?> copy() {
        NativeImg copy = ((PlanarImgFactory)this.factory()).create(this.dimension, (NativeType)((NativeType)this.firstElement()).createVariable());
        Cursor cursor1 = this.cursor();
        Cursor cursor2 = ((PlanarImg)copy).cursor();
        while (((PlanarCursor)cursor1).hasNext()) {
            ((NativeType)((AbstractCursorInt)cursor2).next()).set((Type)((AbstractCursorInt)cursor1).next());
        }
        return copy;
    }

    public static interface PlanarContainerSampler {
        public int getCurrentSliceIndex();
    }
}

