/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.img.planar;

import net.imglib2.img.planar.PlanarCursor;
import net.imglib2.img.planar.PlanarImg;
import net.imglib2.type.NativeType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlanarCursor2D<T extends NativeType<T>>
extends PlanarCursor<T> {
    public PlanarCursor2D(PlanarImg<T, ?> container) {
        super(container);
    }

    @Override
    public boolean hasNext() {
        return this.type.getIndex() < this.lastIndex;
    }

    @Override
    public void fwd() {
        this.type.incIndex();
    }

    @Override
    public void localize(int[] position) {
        int indexInSlice = this.type.getIndex();
        int dim0 = this.container.dimensions[0];
        position[1] = indexInSlice / dim0;
        position[0] = indexInSlice - position[1] * dim0;
    }

    @Override
    public int getIntPosition(int dim) {
        int indexInSlice = this.type.getIndex();
        int dim0 = this.container.dimensions[0];
        int pos1 = indexInSlice / dim0;
        if (dim == 0) {
            return indexInSlice - pos1 * dim0;
        }
        if (dim == 1) {
            return pos1;
        }
        return 0;
    }
}

