/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.img.list;

import net.imglib2.AbstractCursorInt;
import net.imglib2.img.list.AbstractListImg;
import net.imglib2.util.IntervalIndexer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ListCursor<T>
extends AbstractCursorInt<T> {
    private int i;
    private final int maxNumPixels;
    private final AbstractListImg<T> img;

    protected ListCursor(ListCursor<T> cursor) {
        super(cursor.numDimensions());
        this.img = cursor.img;
        this.maxNumPixels = cursor.maxNumPixels;
        this.i = cursor.i;
    }

    public ListCursor(AbstractListImg<T> img) {
        super(img.numDimensions());
        this.img = img;
        this.maxNumPixels = (int)img.size() - 1;
        this.reset();
    }

    @Override
    public T get() {
        return this.img.getPixel(this.i);
    }

    public void set(T t) {
        this.img.setPixel(this.i, t);
    }

    @Override
    public ListCursor<T> copy() {
        return new ListCursor<T>(this);
    }

    @Override
    public ListCursor<T> copyCursor() {
        return this.copy();
    }

    @Override
    public boolean hasNext() {
        return this.i < this.maxNumPixels;
    }

    @Override
    public void jumpFwd(long steps) {
        this.i = (int)((long)this.i + steps);
    }

    @Override
    public void fwd() {
        ++this.i;
    }

    @Override
    public void reset() {
        this.i = -1;
    }

    @Override
    public void localize(int[] position) {
        IntervalIndexer.indexToPosition(this.i, this.img.dim, position);
    }

    @Override
    public int getIntPosition(int d) {
        return IntervalIndexer.indexToPosition(this.i, this.img.dim, this.img.step, d);
    }
}

