/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.img.constant;

import net.imglib2.Cursor;
import net.imglib2.FlatIterationOrder;
import net.imglib2.RandomAccess;
import net.imglib2.img.AbstractImg;
import net.imglib2.img.Img;
import net.imglib2.img.ImgFactory;
import net.imglib2.img.constant.ConstantCursor;
import net.imglib2.img.constant.ConstantImgFactory;
import net.imglib2.img.constant.ConstantLocalizingCursor;
import net.imglib2.img.constant.ConstantRandomAccess;
import net.imglib2.type.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstantImg<T extends Type<T>>
extends AbstractImg<T> {
    final T type;
    ImgFactory<T> factory;
    protected final long[] dim;

    public ConstantImg(long[] size, T type) {
        super(size);
        this.type = type;
        this.dim = size;
    }

    @Override
    public ImgFactory<T> factory() {
        if (this.factory == null) {
            this.factory = new ConstantImgFactory();
        }
        return this.factory;
    }

    @Override
    public Img<T> copy() {
        return new ConstantImg<T>(this.dim, this.type);
    }

    @Override
    public RandomAccess<T> randomAccess() {
        return new ConstantRandomAccess<T>(this.type, this.numDimensions());
    }

    @Override
    public Cursor<T> cursor() {
        return new ConstantCursor<T>(this.type, this.numDimensions(), this.dim, this.numPixels);
    }

    @Override
    public Cursor<T> localizingCursor() {
        long[] max = new long[this.numDimensions()];
        this.max(max);
        return new ConstantLocalizingCursor<T>(this.type, this.numDimensions(), max, this.numPixels);
    }

    @Override
    public FlatIterationOrder iterationOrder() {
        return new FlatIterationOrder(this);
    }
}

