/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.img.constant;

import net.imglib2.AbstractCursor;
import net.imglib2.util.IntervalIndexer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstantCursor<T>
extends AbstractCursor<T> {
    long i;
    final long[] dimensions;
    final long maxNumPixels;
    final T type;

    public ConstantCursor(T type, int numDimensions, long[] dimensions, long numPixels) {
        super(numDimensions);
        this.maxNumPixels = numPixels - 1L;
        this.type = type;
        this.dimensions = dimensions;
    }

    public ConstantCursor(ConstantCursor<T> cursor) {
        super(cursor.n);
        this.maxNumPixels = cursor.maxNumPixels;
        this.type = cursor.type;
        this.i = cursor.i;
        this.dimensions = cursor.dimensions;
    }

    @Override
    public void reset() {
        this.i = -1L;
    }

    @Override
    public T get() {
        return this.type;
    }

    @Override
    public boolean hasNext() {
        return this.i < this.maxNumPixels;
    }

    @Override
    public void fwd() {
        ++this.i;
    }

    @Override
    public void localize(long[] position) {
        IntervalIndexer.indexToPosition(this.i, this.dimensions, position);
    }

    @Override
    public long getLongPosition(int d) {
        return IntervalIndexer.indexToPosition(this.i, this.dimensions, d);
    }

    @Override
    public ConstantCursor<T> copy() {
        return new ConstantCursor<T>(this);
    }

    @Override
    public ConstantCursor<T> copyCursor() {
        return this.copy();
    }
}

