/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.img.cell;

import net.imglib2.exception.IncompatibleTypeException;
import net.imglib2.img.ImgFactory;
import net.imglib2.img.NativeImgFactory;
import net.imglib2.img.basictypeaccess.array.BitArray;
import net.imglib2.img.basictypeaccess.array.ByteArray;
import net.imglib2.img.basictypeaccess.array.CharArray;
import net.imglib2.img.basictypeaccess.array.DoubleArray;
import net.imglib2.img.basictypeaccess.array.FloatArray;
import net.imglib2.img.basictypeaccess.array.IntArray;
import net.imglib2.img.basictypeaccess.array.LongArray;
import net.imglib2.img.basictypeaccess.array.ShortArray;
import net.imglib2.img.cell.CellImg;
import net.imglib2.img.cell.DefaultCell;
import net.imglib2.img.cell.ListImgCells;
import net.imglib2.type.NativeType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CellImgFactory<T extends NativeType<T>>
extends NativeImgFactory<T> {
    protected int[] defaultCellDimensions = new int[]{10};

    public CellImgFactory() {
    }

    public CellImgFactory(int cellSize) {
        this.defaultCellDimensions[0] = cellSize;
    }

    public CellImgFactory(int[] cellDimensions) {
        if (cellDimensions == null || cellDimensions.length == 0) {
            System.err.println("CellContainerFactory(): cellSize is null. Using equal cell size of " + this.defaultCellDimensions[0]);
            return;
        }
        for (int i = 0; i < cellDimensions.length; ++i) {
            if (cellDimensions[i] > 0) continue;
            System.err.println("CellContainerFactory(): cell size in dimension " + i + " is <= 0, using a size of " + this.defaultCellDimensions[0] + ".");
            cellDimensions[i] = this.defaultCellDimensions[0];
        }
        this.defaultCellDimensions = cellDimensions;
    }

    protected long[] checkDimensions(long[] dimensions) {
        if (dimensions == null || dimensions.length == 0) {
            System.err.println("CellContainerFactory(): dimensionality is null. Creating a 1D cell with size 1.");
            dimensions = new long[]{1L};
        }
        for (int i = 0; i < dimensions.length; ++i) {
            if (dimensions[i] > 0L) continue;
            System.err.println("CellContainerFactory(): size of dimension " + i + " is <= 0, using a size of 1.");
            dimensions[i] = 1L;
        }
        return dimensions;
    }

    protected int[] checkCellSize(int[] cellDimensions, long[] dimensions) {
        if (cellDimensions == null) {
            cellDimensions = new int[dimensions.length];
            for (int i = 0; i < cellDimensions.length; ++i) {
                cellDimensions[i] = this.defaultCellDimensions[i < this.defaultCellDimensions.length ? i : 0];
            }
        }
        if (cellDimensions.length != dimensions.length) {
            int[] cellDimensionsNew = new int[dimensions.length];
            for (int i = 0; i < dimensions.length; ++i) {
                cellDimensionsNew[i] = i < cellDimensions.length ? cellDimensions[i] : this.defaultCellDimensions[i < this.defaultCellDimensions.length ? i : 0];
            }
            cellDimensions = cellDimensionsNew;
        }
        return cellDimensions;
    }

    public CellImg<T, ?, ?> create(long[] dim, T type) {
        return (CellImg)type.createSuitableNativeImg(this, dim);
    }

    public CellImg<T, BitArray, DefaultCell<BitArray>> createBitInstance(long[] dimensions, int entitiesPerPixel) {
        dimensions = this.checkDimensions(dimensions);
        int[] cellSize = this.checkCellSize(this.defaultCellDimensions, dimensions);
        return new CellImg(this, new ListImgCells<BitArray>(new BitArray(1), entitiesPerPixel, dimensions, cellSize));
    }

    public CellImg<T, ByteArray, DefaultCell<ByteArray>> createByteInstance(long[] dimensions, int entitiesPerPixel) {
        dimensions = this.checkDimensions(dimensions);
        int[] cellSize = this.checkCellSize(this.defaultCellDimensions, dimensions);
        return new CellImg(this, new ListImgCells<ByteArray>(new ByteArray(1), entitiesPerPixel, dimensions, cellSize));
    }

    public CellImg<T, CharArray, DefaultCell<CharArray>> createCharInstance(long[] dimensions, int entitiesPerPixel) {
        dimensions = this.checkDimensions(dimensions);
        int[] cellSize = this.checkCellSize(this.defaultCellDimensions, dimensions);
        return new CellImg(this, new ListImgCells<CharArray>(new CharArray(1), entitiesPerPixel, dimensions, cellSize));
    }

    public CellImg<T, ShortArray, DefaultCell<ShortArray>> createShortInstance(long[] dimensions, int entitiesPerPixel) {
        dimensions = this.checkDimensions(dimensions);
        int[] cellSize = this.checkCellSize(this.defaultCellDimensions, dimensions);
        return new CellImg(this, new ListImgCells<ShortArray>(new ShortArray(1), entitiesPerPixel, dimensions, cellSize));
    }

    public CellImg<T, IntArray, DefaultCell<IntArray>> createIntInstance(long[] dimensions, int entitiesPerPixel) {
        dimensions = this.checkDimensions(dimensions);
        int[] cellSize = this.checkCellSize(this.defaultCellDimensions, dimensions);
        return new CellImg(this, new ListImgCells<IntArray>(new IntArray(1), entitiesPerPixel, dimensions, cellSize));
    }

    public CellImg<T, LongArray, DefaultCell<LongArray>> createLongInstance(long[] dimensions, int entitiesPerPixel) {
        dimensions = this.checkDimensions(dimensions);
        int[] cellSize = this.checkCellSize(this.defaultCellDimensions, dimensions);
        return new CellImg(this, new ListImgCells<LongArray>(new LongArray(1), entitiesPerPixel, dimensions, cellSize));
    }

    public CellImg<T, FloatArray, DefaultCell<FloatArray>> createFloatInstance(long[] dimensions, int entitiesPerPixel) {
        dimensions = this.checkDimensions(dimensions);
        int[] cellSize = this.checkCellSize(this.defaultCellDimensions, dimensions);
        return new CellImg(this, new ListImgCells<FloatArray>(new FloatArray(1), entitiesPerPixel, dimensions, cellSize));
    }

    public CellImg<T, DoubleArray, DefaultCell<DoubleArray>> createDoubleInstance(long[] dimensions, int entitiesPerPixel) {
        dimensions = this.checkDimensions(dimensions);
        int[] cellSize = this.checkCellSize(this.defaultCellDimensions, dimensions);
        return new CellImg(this, new ListImgCells<DoubleArray>(new DoubleArray(1), entitiesPerPixel, dimensions, cellSize));
    }

    @Override
    public <S> ImgFactory<S> imgFactory(S type) throws IncompatibleTypeException {
        if (NativeType.class.isInstance(type)) {
            return new CellImgFactory<T>(this.defaultCellDimensions);
        }
        throw new IncompatibleTypeException(this, type.getClass().getCanonicalName() + " does not implement NativeType.");
    }
}

