/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.img.cell;

import net.imglib2.AbstractCursor;
import net.imglib2.Cursor;
import net.imglib2.img.AbstractNativeImg;
import net.imglib2.img.NativeImg;
import net.imglib2.img.cell.AbstractCell;
import net.imglib2.img.cell.CellCursor;
import net.imglib2.img.cell.CellImgFactory;
import net.imglib2.img.cell.CellIterationOrder;
import net.imglib2.img.cell.CellLocalizingCursor;
import net.imglib2.img.cell.CellRandomAccess;
import net.imglib2.img.cell.Cells;
import net.imglib2.type.NativeType;
import net.imglib2.type.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CellImg<T extends NativeType<T>, A, C extends AbstractCell<A>>
extends AbstractNativeImg<T, A> {
    protected final CellImgFactory<T> factory;
    protected final Cells<A, C> cells;
    final int[] cellDims;

    private static long[] getDimensionsFromCells(Cells<?, ?> cells) {
        long[] dim = new long[cells.numDimensions()];
        cells.dimensions(dim);
        return dim;
    }

    public CellImg(CellImgFactory<T> factory, Cells<A, C> cells) {
        super(CellImg.getDimensionsFromCells(cells), cells.getEntitiesPerPixel());
        this.factory = factory;
        this.cells = cells;
        this.cellDims = new int[cells.numDimensions()];
        cells.cellDimensions(this.cellDims);
    }

    @Override
    public A update(Object cursor) {
        return ((AbstractCell)((CellContainerSampler)cursor).getCell()).getData();
    }

    protected void getCellPosition(long[] position, long[] cellPos) {
        for (int d = 0; d < this.n; ++d) {
            cellPos[d] = position[d] / (long)this.cellDims[d];
        }
    }

    public CellCursor<T, A, C> cursor() {
        return new CellCursor(this);
    }

    public CellLocalizingCursor<T, A, C> localizingCursor() {
        return new CellLocalizingCursor(this);
    }

    public CellRandomAccess<T, A, C> randomAccess() {
        return new CellRandomAccess(this);
    }

    @Override
    public CellImgFactory<T> factory() {
        return this.factory;
    }

    @Override
    public CellIterationOrder iterationOrder() {
        return new CellIterationOrder(this);
    }

    public CellImg<T, ?, ?> copy() {
        NativeImg copy = ((CellImgFactory)this.factory()).create(this.dimension, (NativeType)((NativeType)this.firstElement()).createVariable());
        Cursor source = this.cursor();
        Cursor target = ((CellImg)copy).cursor();
        while (((CellCursor)source).hasNext()) {
            ((NativeType)((AbstractCursor)target).next()).set((Type)((AbstractCursor)source).next());
        }
        return copy;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface CellContainerSampler<T extends NativeType<T>, A, C extends AbstractCell<A>> {
        public C getCell();
    }
}

