/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.img.basictypeaccess.array;

import net.imglib2.img.basictypeaccess.BitAccess;
import net.imglib2.img.basictypeaccess.array.ArrayDataAccess;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BitArray
implements BitAccess,
ArrayDataAccess<BitArray> {
    protected static final int bitsPerEntity = 32;
    protected final int n;
    protected int[] data;

    public BitArray(int numEntities) {
        this.n = numEntities;
        int numElements = this.n % 32 == 0 ? this.n / 32 : this.n / 32 + 1;
        this.data = new int[numElements];
    }

    @Override
    public boolean getValue(int index) {
        int arrayIndex = index / 32;
        int entry = this.data[arrayIndex];
        int arrayOffset = index % 32;
        int value = entry & 1 << arrayOffset;
        return value != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setValue(int index, boolean value) {
        int arrayIndex = index / 32;
        int arrayOffset = index % 32;
        int[] nArray = this.data;
        synchronized (this.data) {
            this.data[arrayIndex] = value ? this.data[arrayIndex] | 1 << arrayOffset : this.data[arrayIndex] & ~(1 << arrayOffset);
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return;
        }
    }

    public int[] getCurrentStorageArray() {
        return this.data;
    }

    @Override
    public BitArray createArray(int numEntities) {
        return new BitArray(numEntities);
    }
}

