/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.img.array;

import net.imglib2.img.NativeImg;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.img.array.ArrayImgFactory;
import net.imglib2.img.basictypeaccess.ByteAccess;
import net.imglib2.img.basictypeaccess.IntAccess;
import net.imglib2.img.basictypeaccess.ShortAccess;
import net.imglib2.img.basictypeaccess.array.BitArray;
import net.imglib2.img.basictypeaccess.array.ByteArray;
import net.imglib2.img.basictypeaccess.array.DoubleArray;
import net.imglib2.img.basictypeaccess.array.FloatArray;
import net.imglib2.img.basictypeaccess.array.IntArray;
import net.imglib2.img.basictypeaccess.array.LongArray;
import net.imglib2.img.basictypeaccess.array.ShortArray;
import net.imglib2.type.logic.BitType;
import net.imglib2.type.numeric.ARGBType;
import net.imglib2.type.numeric.complex.ComplexDoubleType;
import net.imglib2.type.numeric.complex.ComplexFloatType;
import net.imglib2.type.numeric.integer.ByteType;
import net.imglib2.type.numeric.integer.IntType;
import net.imglib2.type.numeric.integer.LongType;
import net.imglib2.type.numeric.integer.ShortType;
import net.imglib2.type.numeric.integer.UnsignedByteType;
import net.imglib2.type.numeric.integer.UnsignedIntType;
import net.imglib2.type.numeric.integer.UnsignedShortType;
import net.imglib2.type.numeric.real.DoubleType;
import net.imglib2.type.numeric.real.FloatType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ArrayImgs {
    private ArrayImgs() {
    }

    public static final ArrayImg<UnsignedByteType, ByteArray> unsignedBytes(long ... dim) {
        return new ArrayImgFactory().create(dim, new UnsignedByteType());
    }

    public static final ArrayImg<UnsignedByteType, ByteArray> unsignedBytes(byte[] array, long ... dim) {
        ByteArray access = new ByteArray(array);
        ArrayImg<UnsignedByteType, ByteArray> img = new ArrayImg<UnsignedByteType, ByteArray>(access, dim, 1);
        UnsignedByteType t = new UnsignedByteType((NativeImg<UnsignedByteType, ? extends ByteAccess>)img);
        img.setLinkedType(t);
        return img;
    }

    public static final ArrayImg<ByteType, ByteArray> bytes(long ... dim) {
        return new ArrayImgFactory().create(dim, new ByteType());
    }

    public static final ArrayImg<ByteType, ByteArray> bytes(byte[] array, long ... dim) {
        ByteArray access = new ByteArray(array);
        ArrayImg<ByteType, ByteArray> img = new ArrayImg<ByteType, ByteArray>(access, dim, 1);
        ByteType t = new ByteType((NativeImg<ByteType, ? extends ByteAccess>)img);
        img.setLinkedType(t);
        return img;
    }

    public static final ArrayImg<UnsignedShortType, ShortArray> unsignedShorts(long ... dim) {
        return new ArrayImgFactory().create(dim, new UnsignedShortType());
    }

    public static final ArrayImg<UnsignedShortType, ShortArray> unsignedShorts(short[] array, long ... dim) {
        ShortArray access = new ShortArray(array);
        ArrayImg<UnsignedShortType, ShortArray> img = new ArrayImg<UnsignedShortType, ShortArray>(access, dim, 1);
        UnsignedShortType t = new UnsignedShortType((NativeImg<UnsignedShortType, ? extends ShortAccess>)img);
        img.setLinkedType(t);
        return img;
    }

    public static final ArrayImg<ShortType, ShortArray> shorts(long ... dim) {
        return new ArrayImgFactory().create(dim, new ShortType());
    }

    public static final ArrayImg<ShortType, ShortArray> shorts(short[] array, long ... dim) {
        ShortArray access = new ShortArray(array);
        ArrayImg<ShortType, ShortArray> img = new ArrayImg<ShortType, ShortArray>(access, dim, 1);
        ShortType t = new ShortType((NativeImg<ShortType, ? extends ShortAccess>)img);
        img.setLinkedType(t);
        return img;
    }

    public static final ArrayImg<UnsignedIntType, IntArray> unsignedInts(long ... dim) {
        return new ArrayImgFactory().create(dim, new UnsignedIntType());
    }

    public static final ArrayImg<UnsignedIntType, IntArray> unsignedInts(int[] array, long ... dim) {
        IntArray access = new IntArray(array);
        ArrayImg<UnsignedIntType, IntArray> img = new ArrayImg<UnsignedIntType, IntArray>(access, dim, 1);
        UnsignedIntType t = new UnsignedIntType((NativeImg<UnsignedIntType, ? extends IntAccess>)img);
        img.setLinkedType(t);
        return img;
    }

    public static final ArrayImg<IntType, IntArray> ints(long ... dim) {
        return new ArrayImgFactory().create(dim, new IntType());
    }

    public static final ArrayImg<IntType, IntArray> ints(int[] array, long ... dim) {
        IntArray access = new IntArray(array);
        ArrayImg<IntType, IntArray> img = new ArrayImg<IntType, IntArray>(access, dim, 1);
        IntType t = new IntType((NativeImg<IntType, ? extends IntAccess>)img);
        img.setLinkedType(t);
        return img;
    }

    public static final ArrayImg<LongType, LongArray> longs(long ... dim) {
        return new ArrayImgFactory().create(dim, new LongType());
    }

    public static final ArrayImg<LongType, LongArray> longs(long[] array, long ... dim) {
        LongArray access = new LongArray(array);
        ArrayImg<LongType, LongArray> img = new ArrayImg<LongType, LongArray>(access, dim, 1);
        LongType t = new LongType(img);
        img.setLinkedType(t);
        return img;
    }

    public static final ArrayImg<BitType, BitArray> bits(long ... dim) {
        return new ArrayImgFactory().create(dim, new BitType());
    }

    public static final ArrayImg<FloatType, FloatArray> floats(long ... dim) {
        return new ArrayImgFactory().create(dim, new FloatType());
    }

    public static final ArrayImg<FloatType, FloatArray> floats(float[] array, long ... dim) {
        FloatArray access = new FloatArray(array);
        ArrayImg<FloatType, FloatArray> img = new ArrayImg<FloatType, FloatArray>(access, dim, 1);
        FloatType t = new FloatType(img);
        img.setLinkedType(t);
        return img;
    }

    public static final ArrayImg<DoubleType, DoubleArray> doubles(long ... dim) {
        return new ArrayImgFactory().create(dim, new DoubleType());
    }

    public static final ArrayImg<DoubleType, DoubleArray> doubles(double[] array, long ... dim) {
        DoubleArray access = new DoubleArray(array);
        ArrayImg<DoubleType, DoubleArray> img = new ArrayImg<DoubleType, DoubleArray>(access, dim, 1);
        DoubleType t = new DoubleType(img);
        img.setLinkedType(t);
        return img;
    }

    public static final ArrayImg<ARGBType, IntArray> argbs(long ... dim) {
        return new ArrayImgFactory().create(dim, new ARGBType());
    }

    public static final ArrayImg<ARGBType, IntArray> argbs(int[] array, long ... dim) {
        IntArray access = new IntArray(array);
        ArrayImg<ARGBType, IntArray> img = new ArrayImg<ARGBType, IntArray>(access, dim, 1);
        ARGBType t = new ARGBType(img);
        img.setLinkedType(t);
        return img;
    }

    public static final ArrayImg<ComplexFloatType, FloatArray> complexFloats(long ... dim) {
        return new ArrayImgFactory().create(dim, new ComplexFloatType());
    }

    public static final ArrayImg<ComplexFloatType, FloatArray> complexFloats(float[] array, long ... dim) {
        FloatArray access = new FloatArray(array);
        ArrayImg<ComplexFloatType, FloatArray> img = new ArrayImg<ComplexFloatType, FloatArray>(access, dim, 2);
        ComplexFloatType t = new ComplexFloatType(img);
        img.setLinkedType(t);
        return img;
    }

    public static final ArrayImg<ComplexDoubleType, DoubleArray> complexDoubles(long ... dim) {
        return new ArrayImgFactory().create(dim, new ComplexDoubleType());
    }

    public static final ArrayImg<ComplexDoubleType, DoubleArray> complexDoubles(double[] array, long ... dim) {
        DoubleArray access = new DoubleArray(array);
        ArrayImg<ComplexDoubleType, DoubleArray> img = new ArrayImg<ComplexDoubleType, DoubleArray>(access, dim, 2);
        ComplexDoubleType t = new ComplexDoubleType(img);
        img.setLinkedType(t);
        return img;
    }
}

