/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.img.array;

import net.imglib2.AbstractCursorInt;
import net.imglib2.Cursor;
import net.imglib2.FlatIterationOrder;
import net.imglib2.Interval;
import net.imglib2.img.AbstractNativeImg;
import net.imglib2.img.NativeImg;
import net.imglib2.img.array.ArrayCursor;
import net.imglib2.img.array.ArrayImgFactory;
import net.imglib2.img.array.ArrayLocalizingCursor;
import net.imglib2.img.array.ArrayRandomAccess;
import net.imglib2.type.NativeType;
import net.imglib2.type.Type;
import net.imglib2.util.IntervalIndexer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayImg<T extends NativeType<T>, A>
extends AbstractNativeImg<T, A> {
    final int[] steps;
    final int[] dim;
    private final A data;

    public ArrayImg(A data, long[] dim, int entitiesPerPixel) {
        super(dim, entitiesPerPixel);
        this.dim = new int[this.n];
        for (int d = 0; d < this.n; ++d) {
            this.dim[d] = (int)dim[d];
        }
        this.steps = new int[this.n];
        IntervalIndexer.createAllocationSteps(this.dim, this.steps);
        this.data = data;
    }

    @Override
    public A update(Object o) {
        return this.data;
    }

    @Override
    public ArrayCursor<T> cursor() {
        return new ArrayCursor(this);
    }

    @Override
    public ArrayLocalizingCursor<T> localizingCursor() {
        return new ArrayLocalizingCursor(this);
    }

    @Override
    public ArrayRandomAccess<T> randomAccess() {
        return new ArrayRandomAccess(this);
    }

    @Override
    public ArrayRandomAccess<T> randomAccess(Interval interval) {
        return this.randomAccess();
    }

    @Override
    public FlatIterationOrder iterationOrder() {
        return new FlatIterationOrder(this);
    }

    @Override
    public ArrayImgFactory<T> factory() {
        return new ArrayImgFactory();
    }

    public ArrayImg<T, ?> copy() {
        NativeImg copy = ((ArrayImgFactory)this.factory()).create(this.dimension, (NativeType)((NativeType)this.firstElement()).createVariable());
        Cursor source = this.cursor();
        Cursor target = ((ArrayImg)copy).cursor();
        while (((ArrayCursor)source).hasNext()) {
            ((NativeType)((AbstractCursorInt)target).next()).set((Type)((AbstractCursorInt)source).next());
        }
        return copy;
    }
}

