/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.img.array;

import net.imglib2.AbstractCursorInt;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.type.NativeType;
import net.imglib2.util.IntervalIndexer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayCursor<T extends NativeType<T>>
extends AbstractCursorInt<T> {
    protected final T type;
    protected final ArrayImg<T, ?> img;
    protected final int lastIndex;

    protected ArrayCursor(ArrayCursor<T> cursor) {
        super(cursor.numDimensions());
        this.img = cursor.img;
        this.type = this.img.createLinkedType();
        this.lastIndex = (int)this.img.size() - 1;
        this.type.updateIndex(cursor.type.getIndex());
        this.type.updateContainer(this);
    }

    public ArrayCursor(ArrayImg<T, ?> img) {
        super(img.numDimensions());
        this.type = img.createLinkedType();
        this.img = img;
        this.lastIndex = (int)img.size() - 1;
        this.reset();
    }

    @Override
    public T get() {
        return this.type;
    }

    @Override
    public boolean hasNext() {
        return this.type.getIndex() < this.lastIndex;
    }

    @Override
    public void jumpFwd(long steps) {
        this.type.incIndex((int)steps);
    }

    @Override
    public void fwd() {
        this.type.incIndex();
    }

    @Override
    public void reset() {
        this.type.updateIndex(-1);
        this.type.updateContainer(this);
    }

    @Override
    public String toString() {
        return this.type.toString();
    }

    @Override
    public int getIntPosition(int dim) {
        return IntervalIndexer.indexToPosition(this.type.getIndex(), this.img.dim, dim);
    }

    @Override
    public void localize(int[] position) {
        IntervalIndexer.indexToPosition(this.type.getIndex(), this.img.dim, position);
    }

    @Override
    public ArrayCursor<T> copy() {
        return new ArrayCursor<T>(this);
    }

    @Override
    public ArrayCursor<T> copyCursor() {
        return this.copy();
    }
}

