/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.img;

import java.util.ArrayList;
import java.util.Iterator;
import net.imglib2.Cursor;
import net.imglib2.Interval;
import net.imglib2.IterableRealInterval;
import net.imglib2.Positionable;
import net.imglib2.RandomAccess;
import net.imglib2.RealPositionable;
import net.imglib2.display.ColorTable;
import net.imglib2.img.Img;
import net.imglib2.img.ImgFactory;
import net.imglib2.meta.Axes;
import net.imglib2.meta.AxisType;
import net.imglib2.meta.Metadata;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImgPlus<T>
implements Img<T>,
Metadata {
    private static final String DEFAULT_NAME = "Untitled";
    private final Img<T> img;
    private String name;
    private String source = "";
    private final AxisType[] axes;
    private final double[] cal;
    private int validBits;
    private ArrayList<Double> channelMin;
    private ArrayList<Double> channelMax;
    private int compositeChannelCount = 1;
    private final ArrayList<ColorTable> colorTable;

    public ImgPlus(Img<T> img) {
        this(img, null, null, null);
    }

    public ImgPlus(Img<T> img, String name) {
        this(img, name, null, null);
    }

    public ImgPlus(Img<T> img, String name, AxisType[] axes) {
        this(img, name, axes, null);
    }

    public ImgPlus(Img<T> img, Metadata metadata) {
        this(img, metadata.getName(), ImgPlus.getAxes(img, metadata), ImgPlus.getCalibration(img, metadata));
        this.validBits = metadata.getValidBits();
        this.compositeChannelCount = metadata.getCompositeChannelCount();
        int count = metadata.getColorTableCount();
        for (int i = 0; i < count; ++i) {
            this.colorTable.add(metadata.getColorTable(i));
        }
    }

    public ImgPlus(Img<T> img, String name, AxisType[] axes, double[] cal) {
        this.img = img;
        this.name = ImgPlus.validateName(name);
        this.axes = ImgPlus.validateAxes(img.numDimensions(), axes);
        this.cal = ImgPlus.validateCalibration(img.numDimensions(), cal);
        this.channelMin = new ArrayList();
        this.channelMax = new ArrayList();
        this.colorTable = new ArrayList();
        this.setSource("");
    }

    public Img<T> getImg() {
        return this.img;
    }

    @Override
    public RandomAccess<T> randomAccess() {
        return this.img.randomAccess();
    }

    @Override
    public RandomAccess<T> randomAccess(Interval interval) {
        return this.img.randomAccess(interval);
    }

    @Override
    public int numDimensions() {
        return this.img.numDimensions();
    }

    @Override
    public long min(int d) {
        return this.img.min(d);
    }

    @Override
    public void min(long[] min) {
        this.img.min(min);
    }

    @Override
    public void min(Positionable min) {
        this.img.min(min);
    }

    @Override
    public long max(int d) {
        return this.img.max(d);
    }

    @Override
    public void max(long[] max) {
        this.img.max(max);
    }

    @Override
    public void max(Positionable max) {
        this.img.max(max);
    }

    @Override
    public void dimensions(long[] dimensions) {
        this.img.dimensions(dimensions);
    }

    @Override
    public long dimension(int d) {
        return this.img.dimension(d);
    }

    @Override
    public double realMin(int d) {
        return this.img.realMin(d);
    }

    @Override
    public void realMin(double[] min) {
        this.img.realMin(min);
    }

    @Override
    public void realMin(RealPositionable min) {
        this.img.realMin(min);
    }

    @Override
    public double realMax(int d) {
        return this.img.realMax(d);
    }

    @Override
    public void realMax(double[] max) {
        this.img.realMax(max);
    }

    @Override
    public void realMax(RealPositionable max) {
        this.img.realMax(max);
    }

    @Override
    public Cursor<T> cursor() {
        return this.img.cursor();
    }

    @Override
    public Cursor<T> localizingCursor() {
        return this.img.localizingCursor();
    }

    @Override
    public long size() {
        return this.img.size();
    }

    @Override
    public T firstElement() {
        return this.img.firstElement();
    }

    @Override
    public Object iterationOrder() {
        return this.img.iterationOrder();
    }

    @Override
    public boolean equalIterationOrder(IterableRealInterval<?> f) {
        return this.iterationOrder().equals(f.iterationOrder());
    }

    @Override
    public Iterator<T> iterator() {
        return this.img.iterator();
    }

    @Override
    public ImgFactory<T> factory() {
        return this.img.factory();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public int getAxisIndex(AxisType axis) {
        for (int i = 0; i < this.axes.length; ++i) {
            if (this.axes[i] != axis) continue;
            return i;
        }
        return -1;
    }

    @Override
    public AxisType axis(int d) {
        return this.axes[d];
    }

    @Override
    public void axes(AxisType[] target) {
        for (int i = 0; i < target.length; ++i) {
            target[i] = this.axes[i];
        }
    }

    @Override
    public void setAxis(AxisType axis, int d) {
        this.axes[d] = axis;
    }

    @Override
    public double calibration(int d) {
        return this.cal[d];
    }

    @Override
    public void calibration(double[] target) {
        for (int i = 0; i < target.length; ++i) {
            target[i] = this.cal[i];
        }
    }

    @Override
    public void calibration(float[] target) {
        for (int i = 0; i < target.length; ++i) {
            target[i] = (float)this.cal[i];
        }
    }

    @Override
    public void setCalibration(double value, int d) {
        this.cal[d] = value;
    }

    @Override
    public void setCalibration(double[] cal) {
        for (int d = 0; d < cal.length; ++d) {
            this.cal[d] = cal[d];
        }
    }

    @Override
    public void setCalibration(float[] cal) {
        for (int d = 0; d < cal.length; ++d) {
            this.cal[d] = cal[d];
        }
    }

    @Override
    public int getValidBits() {
        return this.validBits;
    }

    @Override
    public void setValidBits(int bits) {
        this.validBits = bits;
    }

    @Override
    public double getChannelMinimum(int c) {
        if (c < 0 || c >= this.channelMin.size()) {
            return Double.NaN;
        }
        Double d = this.channelMin.get(c);
        return d == null ? Double.NaN : d;
    }

    @Override
    public void setChannelMinimum(int c, double min) {
        if (c < 0) {
            throw new IllegalArgumentException("Invalid channel: " + c);
        }
        if (c >= this.channelMin.size()) {
            this.channelMin.ensureCapacity(c + 1);
            for (int i = this.channelMin.size(); i <= c; ++i) {
                this.channelMin.add(null);
            }
        }
        this.channelMin.set(c, min);
    }

    @Override
    public double getChannelMaximum(int c) {
        if (c < 0 || c >= this.channelMax.size()) {
            return Double.NaN;
        }
        Double d = this.channelMax.get(c);
        return d == null ? Double.NaN : d;
    }

    @Override
    public void setChannelMaximum(int c, double max) {
        if (c < 0) {
            throw new IllegalArgumentException("Invalid channel: " + c);
        }
        if (c >= this.channelMax.size()) {
            this.channelMax.ensureCapacity(c + 1);
            for (int i = this.channelMax.size(); i <= c; ++i) {
                this.channelMax.add(null);
            }
        }
        this.channelMax.set(c, max);
    }

    @Override
    public int getCompositeChannelCount() {
        return this.compositeChannelCount;
    }

    @Override
    public void setCompositeChannelCount(int value) {
        this.compositeChannelCount = value;
    }

    @Override
    public ColorTable getColorTable(int no) {
        if (no >= this.colorTable.size()) {
            return null;
        }
        return this.colorTable.get(no);
    }

    @Override
    public void setColorTable(ColorTable cT, int no) {
        this.colorTable.set(no, cT);
    }

    @Override
    public void initializeColorTables(int count) {
        this.colorTable.ensureCapacity(count);
        this.colorTable.clear();
        for (int i = 0; i < count; ++i) {
            this.colorTable.add(null);
        }
    }

    @Override
    public int getColorTableCount() {
        return this.colorTable.size();
    }

    @Override
    public String getSource() {
        return this.source;
    }

    @Override
    public void setSource(String source) {
        this.source = source;
    }

    public static <T> ImgPlus<T> wrap(Img<T> img) {
        if (img instanceof ImgPlus) {
            return (ImgPlus)img;
        }
        return new ImgPlus<T>(img);
    }

    public static <T> ImgPlus<T> wrap(Img<T> img, Metadata metadata) {
        if (img instanceof ImgPlus) {
            return (ImgPlus)img;
        }
        return new ImgPlus<T>(img, metadata);
    }

    private static String validateName(String name) {
        if (name == null) {
            return DEFAULT_NAME;
        }
        return name;
    }

    private static AxisType[] validateAxes(int numDims, AxisType[] axes) {
        if (axes != null && numDims == axes.length) {
            return axes;
        }
        AxisType[] validAxes = new AxisType[numDims];
        block4: for (int i = 0; i < validAxes.length; ++i) {
            if (axes != null && axes.length > i) {
                validAxes[i] = axes[i];
                continue;
            }
            switch (i) {
                case 0: {
                    validAxes[i] = Axes.X;
                    continue block4;
                }
                case 1: {
                    validAxes[i] = Axes.Y;
                    continue block4;
                }
                default: {
                    validAxes[i] = Axes.UNKNOWN;
                }
            }
        }
        return validAxes;
    }

    private static double[] validateCalibration(int numDims, double[] cal) {
        if (cal != null && numDims == cal.length) {
            return cal;
        }
        double[] validCal = new double[numDims];
        for (int i = 0; i < validCal.length; ++i) {
            validCal[i] = cal != null && cal.length > i ? cal[i] : 1.0;
        }
        return validCal;
    }

    private static AxisType[] getAxes(Img<?> img, Metadata metadata) {
        AxisType[] axes = new AxisType[img.numDimensions()];
        for (int i = 0; i < axes.length; ++i) {
            axes[i] = metadata.axis(i);
        }
        return axes;
    }

    private static double[] getCalibration(Img<?> img, Metadata metadata) {
        double[] cal = new double[img.numDimensions()];
        for (int i = 0; i < cal.length; ++i) {
            cal[i] = metadata.calibration(i);
        }
        return cal;
    }

    @Override
    public ImgPlus<T> copy() {
        return new ImgPlus<T>(this.img.copy(), this);
    }
}

