/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.display;

import net.imglib2.FinalInterval;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.converter.Converter;
import net.imglib2.display.AbstractXYProjector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XYRandomAccessibleProjector<A, B>
extends AbstractXYProjector<A, B> {
    protected final RandomAccessibleInterval<B> target;

    public XYRandomAccessibleProjector(RandomAccessible<A> source, RandomAccessibleInterval<B> target, Converter<A, B> converter) {
        super(source, converter);
        this.target = target;
    }

    @Override
    public void map() {
        for (int d = 2; d < this.position.length; ++d) {
            this.min[d] = this.max[d] = this.position[d];
        }
        this.min[0] = this.target.min(0);
        this.min[1] = this.target.min(1);
        this.max[0] = this.target.max(0);
        this.max[1] = this.target.max(1);
        FinalInterval sourceInterval = new FinalInterval(this.min, this.max);
        long cr = -this.target.dimension(0);
        RandomAccess targetRandomAccess = this.target.randomAccess(this.target);
        RandomAccess sourceRandomAccess = this.source.randomAccess(sourceInterval);
        long width = this.target.dimension(0);
        long height = this.target.dimension(1);
        sourceRandomAccess.setPosition(this.min);
        targetRandomAccess.setPosition(this.min[0], 0);
        targetRandomAccess.setPosition(this.min[1], 1);
        for (long y = 0L; y < height; ++y) {
            for (long x = 0L; x < width; ++x) {
                this.converter.convert(sourceRandomAccess.get(), targetRandomAccess.get());
                sourceRandomAccess.fwd(0);
                targetRandomAccess.fwd(0);
            }
            sourceRandomAccess.move(cr, 0);
            targetRandomAccess.move(cr, 0);
            sourceRandomAccess.fwd(1);
            targetRandomAccess.fwd(1);
        }
    }
}

