/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.display;

import net.imglib2.Cursor;
import net.imglib2.FinalInterval;
import net.imglib2.IterableInterval;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessible;
import net.imglib2.converter.Converter;
import net.imglib2.display.AbstractXYProjector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XYProjector<A, B>
extends AbstractXYProjector<A, B> {
    protected final IterableInterval<B> target;
    final int numDimensions;

    public XYProjector(RandomAccessible<A> source, IterableInterval<B> target, Converter<A, B> converter) {
        super(source, converter);
        this.target = target;
        this.numDimensions = source.numDimensions();
    }

    @Override
    public void map() {
        for (int d = 2; d < this.position.length; ++d) {
            this.min[d] = this.max[d] = this.position[d];
        }
        this.min[0] = this.target.min(0);
        this.min[1] = this.target.min(1);
        this.max[0] = this.target.max(0);
        this.max[1] = this.target.max(1);
        FinalInterval sourceInterval = new FinalInterval(this.min, this.max);
        Cursor<B> targetCursor = this.target.localizingCursor();
        RandomAccess sourceRandomAccess = this.source.randomAccess(sourceInterval);
        sourceRandomAccess.setPosition(this.position);
        if (this.numDimensions > 1) {
            while (targetCursor.hasNext()) {
                Object b = targetCursor.next();
                sourceRandomAccess.setPosition(targetCursor.getLongPosition(0), 0);
                sourceRandomAccess.setPosition(targetCursor.getLongPosition(1), 1);
                this.converter.convert(sourceRandomAccess.get(), b);
            }
        } else {
            while (targetCursor.hasNext()) {
                Object b = targetCursor.next();
                sourceRandomAccess.setPosition(targetCursor.getLongPosition(0), 0);
                this.converter.convert(sourceRandomAccess.get(), b);
            }
        }
    }
}

