/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.display;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.Iterator;
import net.imglib2.Cursor;
import net.imglib2.IterableInterval;
import net.imglib2.IterableRealInterval;
import net.imglib2.Positionable;
import net.imglib2.RealPositionable;
import net.imglib2.display.ScreenImage;
import net.imglib2.img.NativeImg;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.img.basictypeaccess.ByteAccess;
import net.imglib2.img.basictypeaccess.array.ByteArray;
import net.imglib2.type.numeric.integer.UnsignedByteType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnsignedByteScreenImage
implements ScreenImage,
IterableInterval<UnsignedByteType> {
    protected final byte[] data;
    protected final ArrayImg<UnsignedByteType, ByteArray> argbArray;
    protected final Image image;
    public static final IndexColorModel GRAY_LUT = UnsignedByteScreenImage.makeGrayLut();

    public static final IndexColorModel makeGrayLut() {
        byte[] c = new byte[256];
        byte[] a = new byte[256];
        for (int i = 0; i < 256; ++i) {
            c[i] = (byte)i;
            a[i] = -1;
        }
        return new IndexColorModel(8, 256, c, c, c, a);
    }

    public UnsignedByteScreenImage(int width, int height) {
        this(width, height, new byte[width * height]);
    }

    public UnsignedByteScreenImage(int width, int height, ByteArray data) {
        this(width, height, data.getCurrentStorageArray());
    }

    public UnsignedByteScreenImage(int width, int height, byte[] data) {
        this.data = data;
        this.argbArray = new ArrayImg(new ByteArray(data), new long[]{width, height}, 1);
        this.argbArray.setLinkedType(new UnsignedByteType((NativeImg<UnsignedByteType, ? extends ByteAccess>)this.argbArray));
        SampleModel sampleModel = GRAY_LUT.createCompatibleWritableRaster(1, 1).getSampleModel().createCompatibleSampleModel(width, height);
        DataBufferByte db = new DataBufferByte(data, width * height, 0);
        WritableRaster raster = Raster.createWritableRaster(sampleModel, db, null);
        this.image = new BufferedImage(GRAY_LUT, raster, false, null);
    }

    @Override
    public Image image() {
        return this.image;
    }

    public byte[] getData() {
        return this.data;
    }

    @Override
    public Cursor<UnsignedByteType> cursor() {
        return this.argbArray.cursor();
    }

    @Override
    public Cursor<UnsignedByteType> localizingCursor() {
        return this.argbArray.localizingCursor();
    }

    @Override
    public Object iterationOrder() {
        return this.argbArray.iterationOrder();
    }

    @Override
    public boolean equalIterationOrder(IterableRealInterval<?> f) {
        return this.iterationOrder().equals(f.iterationOrder());
    }

    @Override
    public long size() {
        return this.argbArray.size();
    }

    @Override
    public double realMax(int d) {
        return this.argbArray.realMax(d);
    }

    @Override
    public void realMax(double[] max) {
        this.argbArray.realMax(max);
    }

    @Override
    public void realMax(RealPositionable max) {
        this.argbArray.realMax(max);
    }

    @Override
    public double realMin(int d) {
        return 0.0;
    }

    @Override
    public void realMin(double[] min) {
        this.argbArray.realMin(min);
    }

    @Override
    public void realMin(RealPositionable min) {
        this.argbArray.realMin(min);
    }

    @Override
    public int numDimensions() {
        return 2;
    }

    @Override
    public Iterator<UnsignedByteType> iterator() {
        return this.argbArray.iterator();
    }

    @Override
    public long max(int d) {
        return this.argbArray.max(d);
    }

    @Override
    public void max(long[] max) {
        this.argbArray.max(max);
    }

    @Override
    public void max(Positionable max) {
        this.argbArray.max(max);
    }

    @Override
    public long min(int d) {
        return 0L;
    }

    @Override
    public void min(long[] min) {
        this.argbArray.min(min);
    }

    @Override
    public void min(Positionable min) {
        this.argbArray.max(min);
    }

    @Override
    public void dimensions(long[] size) {
        this.argbArray.dimensions(size);
    }

    @Override
    public long dimension(int d) {
        return this.argbArray.dimension(d);
    }

    @Override
    public UnsignedByteType firstElement() {
        return this.iterator().next();
    }
}

