/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.display;

import net.imglib2.converter.Converter;
import net.imglib2.display.AbstractLinearRange;
import net.imglib2.display.ColorTable;
import net.imglib2.display.ColorTable8;
import net.imglib2.type.numeric.ARGBType;
import net.imglib2.type.numeric.RealType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RealLUTConverter<R extends RealType<R>>
extends AbstractLinearRange
implements Converter<R, ARGBType> {
    private ColorTable lut = null;

    public RealLUTConverter() {
    }

    public RealLUTConverter(double min, double max, ColorTable lut) {
        super(min, max);
        this.setLUT(lut);
    }

    public ColorTable getLUT() {
        return this.lut;
    }

    public void setLUT(ColorTable lut) {
        this.lut = lut == null ? new ColorTable8() : lut;
    }

    @Override
    public void convert(R input, ARGBType output) {
        double a = input.getRealDouble();
        int argb = this.lut.lookupARGB(this.min, this.max, a);
        output.set(argb);
    }
}

