/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.display;

import java.util.ArrayList;
import net.imglib2.FinalInterval;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.converter.Converter;
import net.imglib2.display.AbstractXYProjector;
import net.imglib2.type.numeric.ARGBType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeXYRandomAccessibleProjector<A>
extends AbstractXYProjector<A, ARGBType> {
    protected final RandomAccessibleInterval<ARGBType> target;
    private final ArrayList<Converter<A, ARGBType>> converters;
    private final int dimIndex;
    private final long positionCount;
    private final long positionMin;
    private final boolean[] composite;
    protected final long[] currentPositions;
    protected final Converter<A, ARGBType>[] currentConverters;

    public CompositeXYRandomAccessibleProjector(RandomAccessibleInterval<A> source, RandomAccessibleInterval<ARGBType> target, ArrayList<Converter<A, ARGBType>> converters, int dimIndex) {
        super(source, null);
        this.target = target;
        this.converters = converters;
        this.dimIndex = dimIndex;
        this.positionCount = dimIndex < 0 ? 1L : source.dimension(dimIndex);
        this.positionMin = dimIndex < 0 ? 0L : source.min(dimIndex);
        int converterCount = converters.size();
        if (this.positionCount != (long)converterCount) {
            throw new IllegalArgumentException("Expected " + this.positionCount + " converters but got " + converterCount);
        }
        this.min[dimIndex] = source.min(dimIndex);
        this.max[dimIndex] = source.max(dimIndex);
        this.composite = new boolean[converterCount];
        this.composite[0] = true;
        this.currentPositions = new long[converterCount];
        this.currentConverters = new Converter[converterCount];
    }

    public void setComposite(int index, boolean on) {
        this.composite[index] = on;
    }

    public boolean isComposite(int index) {
        return this.composite[index];
    }

    public void setComposite(boolean on) {
        for (int i = 0; i < this.composite.length; ++i) {
            this.composite[i] = on;
        }
    }

    public boolean isComposite() {
        for (int i = 0; i < this.composite.length; ++i) {
            if (this.composite[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public void map() {
        for (int d = 2; d < this.position.length; ++d) {
            this.min[d] = this.max[d] = this.position[d];
        }
        this.min[0] = this.target.min(0);
        this.min[1] = this.target.min(1);
        this.max[0] = this.target.max(0);
        this.max[1] = this.target.max(1);
        if (this.dimIndex < 0) {
            RandomAccess sourceRandomAccess = this.source.randomAccess(new FinalInterval(this.min, this.max));
            sourceRandomAccess.setPosition(this.min);
            this.mapSingle(sourceRandomAccess, this.converters.get(0));
            return;
        }
        int size = this.updateCurrentArrays();
        this.min[this.dimIndex] = this.max[this.dimIndex] = this.currentPositions[0];
        for (int i = 1; i < size; ++i) {
            if (this.currentPositions[i] < this.min[this.dimIndex]) {
                this.min[this.dimIndex] = this.currentPositions[i];
                continue;
            }
            if (this.currentPositions[i] <= this.max[this.dimIndex]) continue;
            this.max[this.dimIndex] = this.currentPositions[i];
        }
        RandomAccess sourceRandomAccess = this.source.randomAccess(new FinalInterval(this.min, this.max));
        sourceRandomAccess.setPosition(this.min);
        if (size == 1) {
            sourceRandomAccess.setPosition(this.currentPositions[0], this.dimIndex);
            this.mapSingle(sourceRandomAccess, this.currentConverters[0]);
            return;
        }
        ARGBType bi = new ARGBType();
        RandomAccess targetRandomAccess = this.target.randomAccess();
        targetRandomAccess.setPosition(this.min[1], 1);
        while (targetRandomAccess.getLongPosition(1) <= this.max[1]) {
            sourceRandomAccess.setPosition(this.min[0], 0);
            targetRandomAccess.setPosition(this.min[0], 0);
            while (targetRandomAccess.getLongPosition(0) <= this.max[0]) {
                int aSum = 0;
                int rSum = 0;
                int gSum = 0;
                int bSum = 0;
                for (int i = 0; i < size; ++i) {
                    sourceRandomAccess.setPosition(this.currentPositions[i], this.dimIndex);
                    this.currentConverters[i].convert(sourceRandomAccess.get(), bi);
                    int value = bi.get();
                    int a = ARGBType.alpha(value);
                    int r = ARGBType.red(value);
                    int g = ARGBType.green(value);
                    int b = ARGBType.blue(value);
                    aSum += a;
                    rSum += r;
                    gSum += g;
                    bSum += b;
                }
                if (aSum > 255) {
                    aSum = 255;
                }
                if (rSum > 255) {
                    rSum = 255;
                }
                if (gSum > 255) {
                    gSum = 255;
                }
                if (bSum > 255) {
                    bSum = 255;
                }
                ((ARGBType)targetRandomAccess.get()).set(ARGBType.rgba(rSum, gSum, bSum, aSum));
                sourceRandomAccess.fwd(0);
                targetRandomAccess.fwd(0);
            }
            sourceRandomAccess.fwd(1);
            targetRandomAccess.fwd(1);
        }
    }

    protected int updateCurrentArrays() {
        int currentSize = 0;
        for (int i = 0; i < this.composite.length; ++i) {
            if (!this.composite[i]) continue;
            ++currentSize;
        }
        if (currentSize == 0) {
            this.currentPositions[0] = this.position[this.dimIndex];
            this.currentConverters[0] = this.converters.get((int)(this.position[this.dimIndex] - this.positionMin));
            return 1;
        }
        int j = 0;
        for (int i = 0; i < this.composite.length; ++i) {
            if (!this.composite[i]) continue;
            this.currentPositions[j] = this.positionMin + (long)i;
            this.currentConverters[j] = this.converters.get(i);
            ++j;
        }
        return currentSize;
    }

    protected void mapSingle(RandomAccess<A> sourceRandomAccess, Converter<A, ARGBType> converter) {
        RandomAccess targetRandomAccess = this.target.randomAccess();
        targetRandomAccess.setPosition(this.min[1], 1);
        while (targetRandomAccess.getLongPosition(1) <= this.max[1]) {
            sourceRandomAccess.setPosition(this.min[0], 0);
            targetRandomAccess.setPosition(this.min[0], 0);
            while (targetRandomAccess.getLongPosition(0) <= this.max[0]) {
                converter.convert(sourceRandomAccess.get(), (ARGBType)targetRandomAccess.get());
                sourceRandomAccess.fwd(0);
                targetRandomAccess.fwd(0);
            }
            sourceRandomAccess.fwd(1);
            targetRandomAccess.fwd(1);
        }
    }
}

