/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.display;

import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import net.imglib2.display.ScreenImage;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.img.basictypeaccess.array.IntArray;
import net.imglib2.type.numeric.ARGBType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ARGBScreenImage
extends ArrayImg<ARGBType, IntArray>
implements ScreenImage {
    protected final int[] data;
    protected final BufferedImage image;
    public static final ColorModel ARGB_COLOR_MODEL = new DirectColorModel(32, 0xFF0000, 65280, 255, -16777216);

    public ARGBScreenImage(int width, int height) {
        this(width, height, new int[width * height]);
    }

    public ARGBScreenImage(int width, int height, IntArray data) {
        this(width, height, data.getCurrentStorageArray());
    }

    public ARGBScreenImage(int width, int height, int[] data) {
        super(new IntArray(data), new long[]{width, height}, 1);
        this.setLinkedType(new ARGBType(this));
        this.data = data;
        SampleModel sampleModel = ARGB_COLOR_MODEL.createCompatibleWritableRaster(1, 1).getSampleModel().createCompatibleSampleModel(width, height);
        DataBufferInt dataBuffer = new DataBufferInt(data, width * height, 0);
        WritableRaster rgbRaster = Raster.createWritableRaster(sampleModel, dataBuffer, null);
        this.image = new BufferedImage(ARGB_COLOR_MODEL, rgbRaster, false, null);
    }

    @Override
    public BufferedImage image() {
        return this.image;
    }

    public int[] getData() {
        return this.data;
    }
}

