/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.collection;

import net.imglib2.RealLocalizable;
import net.imglib2.Sampler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class KDTreeNode<T>
implements RealLocalizable,
Sampler<T> {
    protected final int n;
    protected final double[] pos;
    protected final int splitDimension;
    public final KDTreeNode<T> left;
    public final KDTreeNode<T> right;

    public KDTreeNode(RealLocalizable position, int dimension, KDTreeNode<T> left, KDTreeNode<T> right) {
        this.n = position.numDimensions();
        this.pos = new double[this.n];
        position.localize(this.pos);
        this.splitDimension = dimension;
        this.left = left;
        this.right = right;
    }

    protected KDTreeNode(KDTreeNode<T> node) {
        this.n = node.n;
        this.pos = (double[])node.pos.clone();
        this.splitDimension = node.splitDimension;
        this.left = node.left;
        this.right = node.right;
    }

    public final int getSplitDimension() {
        return this.splitDimension;
    }

    public final double getSplitCoordinate() {
        return this.pos[this.splitDimension];
    }

    @Override
    public final int numDimensions() {
        return this.n;
    }

    @Override
    public final void localize(float[] position) {
        for (int d = 0; d < this.n; ++d) {
            position[d] = (float)this.pos[d];
        }
    }

    @Override
    public final void localize(double[] position) {
        for (int d = 0; d < this.n; ++d) {
            position[d] = this.pos[d];
        }
    }

    @Override
    public final float getFloatPosition(int d) {
        return (float)this.pos[d];
    }

    @Override
    public final double getDoublePosition(int d) {
        return this.pos[d];
    }

    @Override
    public abstract KDTreeNode<T> copy();

    public final float squDistanceTo(float[] p) {
        float sum = 0.0f;
        for (int d = 0; d < this.n; ++d) {
            sum = (float)((double)sum + (this.pos[d] - (double)p[d]) * (this.pos[d] - (double)p[d]));
        }
        return sum;
    }

    public final double squDistanceTo(double[] p) {
        double sum = 0.0;
        for (int d = 0; d < this.n; ++d) {
            sum += (this.pos[d] - p[d]) * (this.pos[d] - p[d]);
        }
        return sum;
    }

    public final double squDistanceTo(RealLocalizable p) {
        double sum = 0.0;
        for (int d = 0; d < this.n; ++d) {
            sum += (this.pos[d] - p.getDoublePosition(d)) * (this.pos[d] - p.getDoublePosition(d));
        }
        return sum;
    }
}

