/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2;

import net.imglib2.AbstractRealLocalizable;
import net.imglib2.Localizable;
import net.imglib2.RealLocalizable;
import net.imglib2.RealPositionable;

public class RealPoint
extends AbstractRealLocalizable
implements RealPositionable {
    protected RealPoint(double[] position, boolean copy) {
        super(copy ? (double[])position.clone() : position);
    }

    public RealPoint(int n) {
        super(n);
    }

    public RealPoint(double ... position) {
        this(position, true);
    }

    public RealPoint(float ... position) {
        super(position.length);
        this.setPosition(position);
    }

    public RealPoint(RealLocalizable localizable) {
        super(localizable.numDimensions());
        localizable.localize(this.position);
    }

    public void fwd(int d) {
        int n = d;
        this.position[n] = this.position[n] + 1.0;
    }

    public void bck(int d) {
        int n = d;
        this.position[n] = this.position[n] - 1.0;
    }

    public void move(int distance, int d) {
        int n = d;
        this.position[n] = this.position[n] + (double)distance;
    }

    public void move(long distance, int d) {
        int n = d;
        this.position[n] = this.position[n] + (double)distance;
    }

    public void move(Localizable localizable) {
        for (int d = 0; d < this.n; ++d) {
            int n = d;
            this.position[n] = this.position[n] + localizable.getDoublePosition(d);
        }
    }

    public void move(int[] distance) {
        for (int d = 0; d < this.n; ++d) {
            int n = d;
            this.position[n] = this.position[n] + (double)distance[d];
        }
    }

    public void move(long[] distance) {
        for (int d = 0; d < this.n; ++d) {
            int n = d;
            this.position[n] = this.position[n] + (double)distance[d];
        }
    }

    public void setPosition(Localizable localizable) {
        localizable.localize(this.position);
    }

    public void setPosition(int[] position) {
        for (int d = 0; d < this.n; ++d) {
            this.position[d] = position[d];
        }
    }

    public void setPosition(long[] position) {
        for (int d = 0; d < this.n; ++d) {
            this.position[d] = position[d];
        }
    }

    public void setPosition(int position, int d) {
        this.position[d] = position;
    }

    public void setPosition(long position, int d) {
        this.position[d] = position;
    }

    public void move(float distance, int d) {
        int n = d;
        this.position[n] = this.position[n] + (double)distance;
    }

    public void move(double distance, int d) {
        int n = d;
        this.position[n] = this.position[n] + distance;
    }

    public void move(RealLocalizable localizable) {
        for (int d = 0; d < this.n; ++d) {
            int n = d;
            this.position[n] = this.position[n] + localizable.getDoublePosition(d);
        }
    }

    public void move(float[] distance) {
        for (int d = 0; d < this.n; ++d) {
            int n = d;
            this.position[n] = this.position[n] + (double)distance[d];
        }
    }

    public void move(double[] distance) {
        for (int d = 0; d < this.n; ++d) {
            int n = d;
            this.position[n] = this.position[n] + distance[d];
        }
    }

    public void setPosition(RealLocalizable localizable) {
        localizable.localize(this.position);
    }

    public void setPosition(float[] position) {
        for (int d = 0; d < this.n; ++d) {
            this.position[d] = position[d];
        }
    }

    public void setPosition(double[] position) {
        for (int d = 0; d < this.n; ++d) {
            this.position[d] = position[d];
        }
    }

    public void setPosition(float position, int d) {
        this.position[d] = position;
    }

    public void setPosition(double position, int d) {
        this.position[d] = position;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        int c = 40;
        for (int i = 0; i < this.numDimensions(); ++i) {
            sb.append((char)c);
            sb.append(this.position[i]);
            c = 44;
        }
        sb.append(")");
        return sb.toString();
    }

    public static RealPoint wrap(double[] position) {
        return new RealPoint(position, false);
    }
}

