/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2;

import net.imglib2.Interval;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.outofbounds.OutOfBounds;
import net.imglib2.outofbounds.OutOfBoundsFactory;
import net.imglib2.util.Intervals;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ExtendedRandomAccessibleInterval<T, F extends RandomAccessibleInterval<T>>
implements RandomAccessible<T> {
    protected final F source;
    protected final OutOfBoundsFactory<T, ? super F> factory;

    public ExtendedRandomAccessibleInterval(F source, OutOfBoundsFactory<T, ? super F> factory) {
        this.source = source;
        this.factory = factory;
    }

    @Override
    public final int numDimensions() {
        return this.source.numDimensions();
    }

    @Override
    public final OutOfBounds<T> randomAccess() {
        return this.factory.create(this.source);
    }

    @Override
    public final RandomAccess<T> randomAccess(Interval interval) {
        assert (this.source.numDimensions() == interval.numDimensions());
        if (Intervals.contains(this.source, interval)) {
            return this.source.randomAccess(interval);
        }
        return this.randomAccess();
    }

    public F getSource() {
        return this.source;
    }
}

