/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2;

import net.imglib2.AbstractEuclideanSpace;
import net.imglib2.RealInterval;
import net.imglib2.RealPositionable;

public class AbstractRealInterval
extends AbstractEuclideanSpace
implements RealInterval {
    protected final double[] min;
    protected final double[] max;

    public AbstractRealInterval(RealInterval interval) {
        super(interval.numDimensions());
        this.min = new double[this.n];
        this.max = new double[this.n];
        for (int d = 0; d < this.n; ++d) {
            this.min[d] = this.min[d];
            this.max[d] = this.max[d];
        }
    }

    public AbstractRealInterval(double[] min, double[] max) {
        super(min.length);
        this.min = (double[])min.clone();
        this.max = (double[])max.clone();
    }

    public AbstractRealInterval(double[] dimensions) {
        super(dimensions.length);
        this.min = new double[this.n];
        this.max = new double[this.n];
        for (int d = 0; d < this.n; ++d) {
            this.max[d] = dimensions[d] - 1.0;
        }
    }

    public double realMin(int d) {
        return this.min[d];
    }

    public void realMin(double[] min) {
        for (int d = 0; d < this.n; ++d) {
            min[d] = this.min[d];
        }
    }

    public void realMin(RealPositionable min) {
        for (int d = 0; d < this.n; ++d) {
            min.setPosition(this.min[d], d);
        }
    }

    public double realMax(int d) {
        return this.max[d];
    }

    public void realMax(double[] max) {
        for (int d = 0; d < this.n; ++d) {
            max[d] = this.max[d];
        }
    }

    public void realMax(RealPositionable max) {
        for (int d = 0; d < this.n; ++d) {
            max.setPosition(this.max[d], d);
        }
    }
}

