/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2;

import net.imglib2.AbstractEuclideanSpace;
import net.imglib2.Interval;
import net.imglib2.Positionable;
import net.imglib2.RealPositionable;

public abstract class AbstractInterval
extends AbstractEuclideanSpace
implements Interval {
    protected final long[] min;
    protected final long[] max;

    public AbstractInterval(Interval interval) {
        super(interval.numDimensions());
        this.min = new long[this.n];
        this.max = new long[this.n];
        interval.min(this.min);
        interval.max(this.max);
    }

    public AbstractInterval(long[] min, long[] max) {
        super(min.length);
        assert (min.length == max.length);
        this.min = (long[])min.clone();
        this.max = (long[])max.clone();
    }

    public AbstractInterval(long[] dimensions) {
        super(dimensions.length);
        this.min = new long[this.n];
        this.max = new long[this.n];
        for (int d = 0; d < this.n; ++d) {
            this.max[d] = dimensions[d] - 1L;
        }
    }

    public double realMin(int d) {
        assert (d >= 0);
        assert (d < this.n);
        return this.min[d];
    }

    public void realMin(double[] minimum) {
        assert (minimum.length == this.n);
        for (int d = 0; d < this.n; ++d) {
            minimum[d] = this.min[d];
        }
    }

    public void realMin(RealPositionable minimum) {
        assert (minimum.numDimensions() == this.n);
        minimum.setPosition(this.min);
    }

    public double realMax(int d) {
        assert (d >= 0);
        assert (d < this.n);
        return this.max[d];
    }

    public void realMax(double[] maximum) {
        assert (maximum.length == this.n);
        for (int d = 0; d < this.n; ++d) {
            maximum[d] = this.max[d];
        }
    }

    public void realMax(RealPositionable m) {
        assert (m.numDimensions() == this.n);
        m.setPosition(this.max);
    }

    public long min(int d) {
        assert (d >= 0);
        assert (d < this.n);
        return this.min[d];
    }

    public void min(long[] minimum) {
        assert (minimum.length == this.n);
        for (int d = 0; d < this.n; ++d) {
            minimum[d] = this.min[d];
        }
    }

    public void min(Positionable m) {
        assert (m.numDimensions() == this.n);
        m.setPosition(this.min);
    }

    public long max(int d) {
        assert (d >= 0);
        assert (d < this.n);
        return this.max[d];
    }

    public void max(long[] maximum) {
        assert (maximum.length == this.n);
        for (int d = 0; d < this.n; ++d) {
            maximum[d] = this.max[d];
        }
    }

    public void max(Positionable m) {
        assert (m.numDimensions() == this.n);
        m.setPosition(this.max);
    }

    public void dimensions(long[] dimensions) {
        assert (dimensions.length == this.n);
        for (int d = 0; d < this.n; ++d) {
            dimensions[d] = this.max[d] - this.min[d] + 1L;
        }
    }

    public long dimension(int d) {
        assert (d >= 0);
        assert (d < this.n);
        return this.max[d] - this.min[d] + 1L;
    }
}

