/*
 * Decompiled with CFR 0.152.
 */
package pojos;

import omero.RDouble;
import omero.RTime;
import omero.model.WellSample;
import omero.model.WellSampleI;
import pojos.DataObject;
import pojos.ImageData;

public class WellSampleData
extends DataObject {
    private ImageData image;

    public WellSampleData() {
        this.setDirty(true);
        this.setValue(new WellSampleI());
    }

    public WellSampleData(WellSample wellSample) {
        if (wellSample == null) {
            throw new IllegalArgumentException("Object cannot be null.");
        }
        this.setValue(wellSample);
    }

    public ImageData getImage() {
        if (this.image == null) {
            this.image = new ImageData(this.asWellSample().getImage());
        }
        return this.image;
    }

    public void setImage(ImageData newValue) {
        if (newValue == null) {
            return;
        }
        this.setDirty(true);
        this.asWellSample().setImage(newValue.asImage());
    }

    public double getPositionX() {
        RDouble value = this.asWellSample().getPosX();
        if (value == null) {
            return 0.0;
        }
        return value.getValue();
    }

    public double getPositionY() {
        RDouble value = this.asWellSample().getPosY();
        if (value == null) {
            return 0.0;
        }
        return value.getValue();
    }

    public long getStartTime() {
        RTime value = this.asWellSample().getTimepoint();
        if (value == null) {
            return 0L;
        }
        return value.getValue();
    }
}

