/*
 * Decompiled with CFR 0.152.
 */
package pojos;

import java.awt.Color;
import java.awt.Font;
import omero.RInt;
import omero.RString;
import omero.model.Shape;
import omero.rtypes;
import pojos.DataObject;

public class ShapeSettingsData
extends DataObject {
    public static final String LINE_CAP_BUTT = "Butt";
    public static final String LINE_CAP_ROUND = "Round";
    public static final String LINE_CAP_SQUARE = "Square";
    public static final Color DEFAULT_FILL_COLOUR = new Color(0, 0, 0, 64);
    public static final Color DEFAULT_FILL_COLOUR_ALPHA = new Color(0, 0, 0, 32);
    public static final Color DEFAULT_STROKE_COLOUR = new Color(196, 196, 196, 196);
    public static final int DEFAULT_FONT_SIZE = 12;
    public static final String DEFAULT_FONT_FAMILY = "sans-serif";
    public static final double DEFAULT_STROKE_WIDTH = 1.0;
    public static final String FONT_ITALIC = "Italic";
    public static final String FONT_BOLD = "Bold";
    public static final String FONT_BOLD_ITALIC = "BoldItalic";
    public static final String FONT_REGULAR = "Normal";

    private String formatFontStyle(String value) {
        if (value == null) {
            return FONT_REGULAR;
        }
        String v = value.trim();
        v = v.toLowerCase();
        if (FONT_ITALIC.toLowerCase().equals(v)) {
            return FONT_ITALIC;
        }
        if (FONT_BOLD.toLowerCase().equals(v)) {
            return FONT_BOLD;
        }
        if (FONT_BOLD_ITALIC.toLowerCase().equals(v)) {
            return FONT_BOLD_ITALIC;
        }
        return FONT_REGULAR;
    }

    ShapeSettingsData(Shape shape) {
        this.setValue(shape);
        this.setFontStyle(FONT_REGULAR);
    }

    public String getFillRule() {
        Shape shape = (Shape)this.asIObject();
        RString value = shape.getFillRule();
        if (value == null) {
            return "";
        }
        return value.getValue();
    }

    public void setFillRule(String fillRule) {
        Shape shape = (Shape)this.asIObject();
        if (shape == null) {
            throw new IllegalArgumentException("No shape specified.");
        }
        shape.setFillRule(rtypes.rstring(fillRule));
        this.setDirty(true);
    }

    public Color getFill() {
        Shape shape = (Shape)this.asIObject();
        RInt value = shape.getFillColor();
        if (value == null) {
            return DEFAULT_FILL_COLOUR;
        }
        return new Color(value.getValue(), true);
    }

    public void setFill(Color fillColour) {
        Shape shape = (Shape)this.asIObject();
        if (shape == null) {
            throw new IllegalArgumentException("No shape specified.");
        }
        shape.setFillColor(rtypes.rint(fillColour.getRGB()));
        this.setDirty(true);
    }

    public Color getStroke() {
        Shape shape = (Shape)this.asIObject();
        RInt value = shape.getStrokeColor();
        if (value == null) {
            return DEFAULT_STROKE_COLOUR;
        }
        return new Color(value.getValue(), true);
    }

    public void setStroke(Color strokeColour) {
        Shape shape = (Shape)this.asIObject();
        if (shape == null) {
            throw new IllegalArgumentException("No shape specified.");
        }
        shape.setStrokeColor(rtypes.rint(strokeColour.getRGB()));
        this.setDirty(true);
    }

    public double getStrokeWidth() {
        Shape shape = (Shape)this.asIObject();
        RInt value = shape.getStrokeWidth();
        if (value == null) {
            return 1.0;
        }
        return value.getValue();
    }

    public void setStrokeWidth(double strokeWidth) {
        Shape shape = (Shape)this.asIObject();
        if (shape == null) {
            throw new IllegalArgumentException("No shape specified.");
        }
        shape.setStrokeWidth(rtypes.rint((int)strokeWidth));
        this.setDirty(true);
    }

    public double[] getStrokeDashArray() {
        Shape shape = (Shape)this.asIObject();
        RString value = shape.getStrokeDashArray();
        if (value == null) {
            return null;
        }
        String v = value.getValue();
        String[] values = v.split("\\s*,\\s*");
        double[] dashes = new double[values.length];
        for (int i = 0; i < values.length; ++i) {
            dashes[i] = new Double(values[i]);
        }
        return dashes;
    }

    public void setStrokeDashArray(double[] dashArray) {
        Shape shape = (Shape)this.asIObject();
        if (shape == null) {
            throw new IllegalArgumentException("No shape specified.");
        }
        if (dashArray == null || dashArray.length < 2) {
            return;
        }
        StringBuffer values = new StringBuffer();
        for (int i = 0; i < dashArray.length - 1; ++i) {
            values.append(dashArray[i] + ",");
        }
        String v = values.toString() + dashArray[dashArray.length - 1];
        shape.setStrokeDashArray(rtypes.rstring(v));
        this.setDirty(true);
    }

    public int getLineCap() {
        Shape shape = (Shape)this.asIObject();
        RString value = shape.getStrokeLineCap();
        if (value == null) {
            return 0;
        }
        String v = value.getValue();
        if (LINE_CAP_BUTT.equals(v)) {
            return 0;
        }
        if (LINE_CAP_ROUND.equals(v)) {
            return 1;
        }
        if (LINE_CAP_SQUARE.equals(v)) {
            return 2;
        }
        return 0;
    }

    public void setLineCap(int lineCap) {
        Shape shape = (Shape)this.asIObject();
        if (shape == null) {
            throw new IllegalArgumentException("No shape specified.");
        }
        switch (lineCap) {
            case 0: {
                shape.setStrokeLineCap(rtypes.rstring(LINE_CAP_BUTT));
                break;
            }
            case 1: {
                shape.setStrokeLineCap(rtypes.rstring(LINE_CAP_BUTT));
                break;
            }
            case 2: {
                shape.setStrokeLineCap(rtypes.rstring(LINE_CAP_BUTT));
                break;
            }
            default: {
                shape.setStrokeLineCap(rtypes.rstring(LINE_CAP_BUTT));
            }
        }
        this.setDirty(true);
    }

    public Font getFont() {
        int style = 0;
        if (this.isFontBold()) {
            style |= 1;
        }
        if (this.isFontItalic()) {
            style |= 2;
        }
        return new Font(this.getFontFamily(), style, this.getFontSize());
    }

    public String getFontFamily() {
        Shape shape = (Shape)this.asIObject();
        if (shape == null) {
            throw new IllegalArgumentException("No shape specified.");
        }
        RString family = shape.getFontFamily();
        if (family != null) {
            return family.getValue();
        }
        return DEFAULT_FONT_FAMILY;
    }

    public void setFontFamily(String fontFamily) {
        Shape shape = (Shape)this.asIObject();
        if (shape == null) {
            throw new IllegalArgumentException("No shape specified.");
        }
        if (fontFamily == null || fontFamily.trim().length() == 0) {
            fontFamily = DEFAULT_FONT_FAMILY;
        }
        shape.setFontFamily(rtypes.rstring(fontFamily));
        this.setDirty(true);
    }

    public int getFontSize() {
        Shape shape = (Shape)this.asIObject();
        if (shape == null) {
            throw new IllegalArgumentException("No shape specified.");
        }
        RInt size = shape.getFontSize();
        if (size != null) {
            return size.getValue();
        }
        return 12;
    }

    public void setFontSize(int fontSize) {
        Shape shape = (Shape)this.asIObject();
        if (shape == null) {
            throw new IllegalArgumentException("No shape specified.");
        }
        if (fontSize <= 0) {
            fontSize = 12;
        }
        shape.setFontSize(rtypes.rint(fontSize));
        this.setDirty(true);
    }

    public String getFontStyle() {
        Shape shape = (Shape)this.asIObject();
        if (shape == null) {
            throw new IllegalArgumentException("No shape specified.");
        }
        RString style = shape.getFontStyle();
        if (style != null) {
            return style.getValue();
        }
        return FONT_REGULAR;
    }

    public void setFontStyle(String fontStyle) {
        Shape shape = (Shape)this.asIObject();
        if (shape == null) {
            throw new IllegalArgumentException("No shape specified.");
        }
        shape.setFontStyle(rtypes.rstring(this.formatFontStyle(fontStyle)));
        shape.setFontWeight(null);
        this.setDirty(true);
    }

    public String getMarkerStart() {
        return "";
    }

    public String getMarkerEnd() {
        return "";
    }

    public String setMarkerStart(String start) {
        return "";
    }

    public String setMarkerEnd(String end) {
        return "";
    }

    public boolean isFontItalic() {
        String value = this.getFontStyle();
        value = value.toLowerCase();
        String f = FONT_ITALIC.toLowerCase();
        String f1 = FONT_BOLD_ITALIC.toLowerCase();
        return f.equals(value) || f1.equals(value);
    }

    public boolean isFontBold() {
        String value;
        Shape shape = (Shape)this.asIObject();
        if (shape == null) {
            throw new IllegalArgumentException("No shape specified.");
        }
        String f = FONT_BOLD.toLowerCase();
        String f1 = FONT_BOLD_ITALIC.toLowerCase();
        RString weight = shape.getFontWeight();
        if (weight != null) {
            value = weight.getValue();
            if ((value = value.toLowerCase()).trim().length() > 0) {
                return f.equals(value) || f1.equals(value);
            }
        }
        value = this.getFontStyle();
        return f.equals(value = value.toLowerCase()) || f1.equals(value);
    }
}

