/*
 * Decompiled with CFR 0.152.
 */
package pojos;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import omero.model.Ellipse;
import omero.model.Image;
import omero.model.Label;
import omero.model.Line;
import omero.model.Mask;
import omero.model.Point;
import omero.model.Polygon;
import omero.model.Polyline;
import omero.model.Rect;
import omero.model.Roi;
import omero.model.RoiI;
import omero.model.Shape;
import pojos.DataObject;
import pojos.EllipseData;
import pojos.ImageData;
import pojos.LineData;
import pojos.MaskData;
import pojos.PointData;
import pojos.PolygonData;
import pojos.PolylineData;
import pojos.ROICoordinate;
import pojos.RectangleData;
import pojos.ShapeData;
import pojos.TextData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ROIData
extends DataObject {
    private TreeMap<ROICoordinate, List<ShapeData>> roiShapes;
    private boolean clientSide;

    private void initialize() {
        this.roiShapes = new TreeMap(new ROICoordinate());
        Roi roi = (Roi)this.asIObject();
        List<Shape> shapes = roi.copyShapes();
        if (shapes == null) {
            return;
        }
        for (Shape shape : shapes) {
            List<Object> data;
            ShapeData s = null;
            if (shape instanceof Rect) {
                s = new RectangleData(shape);
            } else if (shape instanceof Ellipse) {
                s = new EllipseData(shape);
            } else if (shape instanceof Point) {
                s = new PointData(shape);
            } else if (shape instanceof Polyline) {
                s = new PolylineData(shape);
            } else if (shape instanceof Polygon) {
                s = new PolygonData(shape);
            } else if (shape instanceof Label) {
                s = new TextData(shape);
            } else if (shape instanceof Line) {
                s = new LineData(shape);
            } else if (shape instanceof Mask) {
                s = new MaskData(shape);
            }
            if (s == null) continue;
            ROICoordinate coord = new ROICoordinate(s.getZ(), s.getT());
            if (!this.roiShapes.containsKey(coord)) {
                data = new ArrayList();
                this.roiShapes.put(coord, data);
            } else {
                data = this.roiShapes.get(coord);
            }
            data.add(s);
        }
    }

    public ROIData(Roi roi) {
        this.setValue(roi);
        if (roi != null) {
            this.initialize();
        }
    }

    public ROIData() {
        this.setValue(new RoiI());
        this.roiShapes = new TreeMap(new ROICoordinate());
    }

    public void setImage(Image image) {
        Roi roi = (Roi)this.asIObject();
        if (roi == null) {
            throw new IllegalArgumentException("No Roi specified.");
        }
        roi.setImage(image);
        this.setDirty(true);
    }

    public ImageData getImage() {
        Roi roi = (Roi)this.asIObject();
        if (roi == null) {
            throw new IllegalArgumentException("No Roi specified.");
        }
        Image image = roi.getImage();
        if (image == null) {
            return null;
        }
        return new ImageData(image);
    }

    public void addShapeData(ShapeData shape) {
        List<Object> shapeList;
        Roi roi = (Roi)this.asIObject();
        if (roi == null) {
            throw new IllegalArgumentException("No Roi specified.");
        }
        ROICoordinate coord = shape.getROICoordinate();
        if (!this.roiShapes.containsKey(coord)) {
            shapeList = new ArrayList();
            this.roiShapes.put(coord, shapeList);
        } else {
            shapeList = this.roiShapes.get(coord);
        }
        shapeList.add(shape);
        roi.addShape((Shape)shape.asIObject());
        this.setDirty(true);
    }

    public void removeShapeData(ShapeData shape) {
        Roi roi = (Roi)this.asIObject();
        if (roi == null) {
            throw new IllegalArgumentException("No Roi specified.");
        }
        ROICoordinate coord = shape.getROICoordinate();
        List<ShapeData> shapeList = this.roiShapes.get(coord);
        shapeList.remove(shape);
        roi.removeShape((Shape)shape.asIObject());
        this.setDirty(true);
    }

    public int getPlaneCount() {
        return this.roiShapes.size();
    }

    public int getShapeCount() {
        Iterator<ROICoordinate> i = this.roiShapes.keySet().iterator();
        int cnt = 0;
        while (i.hasNext()) {
            List<ShapeData> shapeList = this.roiShapes.get(i.next());
            cnt += shapeList.size();
        }
        return cnt;
    }

    public List<ShapeData> getShapes(int z, int t) {
        return this.roiShapes.get(new ROICoordinate(z, t));
    }

    public Iterator<List<ShapeData>> getIterator() {
        return this.roiShapes.values().iterator();
    }

    public ROICoordinate firstPlane() {
        return this.roiShapes.firstKey();
    }

    public ROICoordinate lastPlane() {
        return this.roiShapes.lastKey();
    }

    public Iterator<List<ShapeData>> getShapesInRange(ROICoordinate start, ROICoordinate end) {
        return this.roiShapes.subMap(start, end).values().iterator();
    }

    public boolean isClientSide() {
        return this.clientSide;
    }

    public void setClientSide(boolean clientSide) {
        this.clientSide = clientSide;
    }

    public void setNamespaceKeywords(String namespace, String[] keywords) {
        if (namespace.equals("") || keywords.length == 0) {
            return;
        }
        Roi roi = (Roi)this.asIObject();
        if (roi == null) {
            throw new IllegalArgumentException("No Roi specified.");
        }
        if (keywords.length == 0) {
            this.removeNamespace(namespace);
        } else {
            Map<String, List<String>> map = this.getNamespaceKeywords();
            ArrayList<String> keywordsList = new ArrayList<String>();
            for (String keyword : keywords) {
                if (keyword.equals("")) continue;
                keywordsList.add(keyword);
            }
            if (keywordsList.size() == 0) {
                return;
            }
            map.put(namespace, keywordsList);
            this.setNamespaceMap(map);
            this.setDirty(true);
        }
    }

    public void removeNamespace(String namespace) {
        Roi roi = (Roi)this.asIObject();
        if (roi == null) {
            throw new IllegalArgumentException("No Roi specified.");
        }
        Map<String, List<String>> map = this.getNamespaceKeywords();
        if (map.containsKey(namespace)) {
            map.remove(namespace);
            this.setNamespaceMap(map);
            this.setDirty(true);
        }
    }

    public void setNamespaceMap(Map<String, List<String>> map) {
        Roi roi = (Roi)this.asIObject();
        if (roi == null) {
            throw new IllegalArgumentException("No Roi specified.");
        }
        Iterator<String> namespaceIterator = map.keySet().iterator();
        String[] namespaces = new String[map.size()];
        int k = 0;
        while (namespaceIterator.hasNext()) {
            namespaces[k++] = namespaceIterator.next();
        }
        roi.setNamespaces(namespaces);
        int maxKeywordLength = 0;
        for (String namespace : namespaces) {
            maxKeywordLength = Math.max(maxKeywordLength, map.get(namespace).size());
        }
        String[][] keywords = new String[namespaces.length][maxKeywordLength];
        for (int i = 0; i < namespaces.length; ++i) {
            List<String> keywordsList = map.get(namespaces[i]);
            for (int j = 0; j < map.get(namespaces[i]).size(); ++j) {
                keywords[i][j] = keywordsList.get(j);
            }
        }
        roi.setKeywords(keywords);
        this.setDirty(true);
    }

    public List<String> getNamespaces() {
        Roi roi = (Roi)this.asIObject();
        if (roi == null) {
            throw new IllegalArgumentException("No Roi specified.");
        }
        ArrayList<String> namespaces = new ArrayList<String>();
        String[] namespacesArray = roi.getNamespaces();
        if (namespacesArray != null) {
            for (String namespace : namespacesArray) {
                namespaces.add(namespace);
            }
        }
        return namespaces;
    }

    public List<String> getNamespaceKeywords(String namespace) {
        Map<String, List<String>> map = this.getNamespaceKeywords();
        if (!map.containsKey(namespace)) {
            throw new IllegalArgumentException("Namespace " + namespace + " does not exist.");
        }
        return map.get(namespace);
    }

    public Map<String, List<String>> getNamespaceKeywords() {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        Roi roi = (Roi)this.asIObject();
        if (roi == null) {
            throw new IllegalArgumentException("No Roi specified.");
        }
        List<String> namespaces = this.getNamespaces();
        String[][] namespaceKeywords = roi.getKeywords();
        if (namespaceKeywords == null) {
            return map;
        }
        if (namespaces.size() != namespaceKeywords.length) {
            throw new IllegalArgumentException("Namespaces length = " + namespaces.size() + " not equal to keywords namespaces " + namespaceKeywords.length);
        }
        for (int index = 0; index < namespaces.size(); ++index) {
            String[] keywords;
            ArrayList<String> keywordList = new ArrayList<String>();
            for (String keyword : keywords = namespaceKeywords[index]) {
                keywordList.add(keyword);
            }
            map.put(namespaces.get(index), keywordList);
        }
        return map;
    }
}

