/*
 * Decompiled with CFR 0.152.
 */
package pojos;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import omero.RString;
import omero.model.Project;
import omero.model.ProjectDatasetLink;
import omero.model.ProjectI;
import omero.rtypes;
import pojos.DataObject;
import pojos.DatasetData;
import pojos.SetMutator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectData
extends DataObject {
    public static final String NAME = "ome.model.containers.Project_name";
    public static final String DESCRIPTION = "ome.model.containers.Project_description";
    public static final String DATASET_LINKS = "ome.model.containers.Project_datasetLinks";
    private Set datasets;

    public ProjectData() {
        this.setDirty(true);
        this.setValue(new ProjectI());
    }

    public ProjectData(Project project) {
        if (project == null) {
            throw new IllegalArgumentException("Object cannot null.");
        }
        this.setValue(project);
    }

    public void setName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("The name cannot be null.");
        }
        this.setDirty(true);
        this.asProject().setName(rtypes.rstring(name));
    }

    public String getName() {
        RString n = this.asProject().getName();
        if (n == null || n.getValue() == null) {
            throw new IllegalStateException("The name should never have been null");
        }
        return n.getValue();
    }

    public void setDescription(String description) {
        this.setDirty(true);
        this.asProject().setDescription(rtypes.rstring(description));
    }

    public String getDescription() {
        RString d = this.asProject().getDescription();
        return d == null ? null : d.getValue();
    }

    public Map<Long, Long> getAnnotationsCounts() {
        return this.asProject().getAnnotationLinksCountPerOwner();
    }

    public Set<DatasetData> getDatasets() {
        if (this.datasets == null && this.asProject().sizeOfDatasetLinks() >= 0) {
            this.datasets = new HashSet();
            List<ProjectDatasetLink> links = this.asProject().copyDatasetLinks();
            for (ProjectDatasetLink link : links) {
                this.datasets.add(new DatasetData(link.getChild()));
            }
        }
        return this.datasets == null ? null : new HashSet(this.datasets);
    }

    public void setDatasets(Set<DatasetData> newValue) {
        Set<DatasetData> currentValue = this.getDatasets();
        SetMutator<DatasetData> m = new SetMutator<DatasetData>(currentValue, newValue);
        while (m.moreDeletions()) {
            this.setDirty(true);
            this.asProject().unlinkDataset(m.nextDeletion().asDataset());
        }
        while (m.moreAdditions()) {
            this.setDirty(true);
            this.asProject().linkDataset(m.nextAddition().asDataset());
        }
        this.datasets = new HashSet<DatasetData>(m.result());
    }
}

