/*
 * Decompiled with CFR 0.152.
 */
package pojos;

import omero.RDouble;
import omero.RInt;
import omero.model.AcquisitionMode;
import omero.model.Binning;
import omero.model.ContrastMethod;
import omero.model.DetectorSettings;
import omero.model.DetectorSettingsI;
import omero.model.FilterSet;
import omero.model.Illumination;
import omero.model.LightPath;
import omero.model.LightSettings;
import omero.model.LightSettingsI;
import omero.model.LightSource;
import omero.model.LogicalChannel;
import omero.rtypes;
import pojos.DataObject;
import pojos.DetectorData;
import pojos.FilterSetData;
import pojos.LightPathData;
import pojos.LightSourceData;
import pojos.OTFData;

public class ChannelAcquisitionData
extends DataObject {
    private DetectorSettings detectorSettings;
    private LightSettings lightSettings;
    private FilterSetData filterSet;
    private LightPathData lightPath;
    private LightSourceData ligthSource;
    private boolean detectorSettingsDirty;
    private boolean ligthSourceSettingsDirty;
    private DetectorData detector;
    private OTFData otf;
    private Binning binning;

    public ChannelAcquisitionData(LogicalChannel channel) {
        LightPath path;
        if (channel == null) {
            throw new IllegalArgumentException("Object cannot null.");
        }
        this.setValue(channel);
        this.detectorSettings = channel.getDetectorSettings();
        this.lightSettings = channel.getLightSourceSettings();
        FilterSet set = channel.getFilterSet();
        if (set != null) {
            this.filterSet = new FilterSetData(set);
        }
        if ((path = channel.getLightPath()) != null) {
            this.lightPath = new LightPathData(path);
        }
        if (channel.getOtf() != null) {
            this.otf = new OTFData(channel.getOtf());
        }
    }

    public DetectorData getDetector() {
        if (this.detectorSettings == null) {
            return null;
        }
        if (this.detector == null) {
            this.detector = new DetectorData(this.detectorSettings.getDetector());
        }
        return this.detector;
    }

    public OTFData getOTF() {
        return this.otf;
    }

    public Double getDetectorSettingsOffset() {
        if (this.detectorSettings == null) {
            return null;
        }
        RDouble value = this.detectorSettings.getOffsetValue();
        if (value == null) {
            return null;
        }
        return value.getValue();
    }

    public Double getDetectorSettingsGain() {
        if (this.detectorSettings == null) {
            return null;
        }
        RDouble value = this.detectorSettings.getGain();
        if (value == null) {
            return null;
        }
        return value.getValue();
    }

    public Double getDetectorSettingsVoltage() {
        if (this.detectorSettings == null) {
            return null;
        }
        RDouble value = this.detectorSettings.getVoltage();
        if (value == null) {
            return null;
        }
        return value.getValue();
    }

    public Double getDetectorSettingsReadOutRate() {
        if (this.detectorSettings == null) {
            return null;
        }
        RDouble value = this.detectorSettings.getReadOutRate();
        if (value == null) {
            return null;
        }
        return value.getValue();
    }

    public String getDetectorSettingsBinning() {
        if (this.detectorSettings == null) {
            return "";
        }
        Binning value = this.detectorSettings.getBinning();
        if (value == null) {
            return "";
        }
        return value.getValue().getValue();
    }

    public Double getLigthSettingsAttenuation() {
        if (this.lightSettings == null) {
            return null;
        }
        RDouble value = this.lightSettings.getAttenuation();
        if (value == null) {
            return null;
        }
        return value.getValue();
    }

    public Integer getLigthSettingsWavelength() {
        if (this.lightSettings == null) {
            return null;
        }
        RInt value = this.lightSettings.getWavelength();
        if (value == null) {
            return null;
        }
        return value.getValue();
    }

    public boolean hasFilter() {
        return this.filterSet != null;
    }

    public boolean hasLightPath() {
        return this.lightPath != null;
    }

    public boolean hasDectector() {
        return this.getDetector() != null;
    }

    public void setLigthSettingsAttenuation(double value) {
        this.ligthSourceSettingsDirty = true;
        if (this.lightSettings == null) {
            this.lightSettings = new LightSettingsI();
        }
        this.lightSettings.setAttenuation(rtypes.rdouble(value));
    }

    public void setLigthSettingsWavelength(int value) {
        this.ligthSourceSettingsDirty = true;
        if (this.lightSettings == null) {
            this.lightSettings = new LightSettingsI();
        }
        this.lightSettings.setWavelength(rtypes.rint(value));
    }

    public void setDetectorSettingOffset(double value) {
        this.detectorSettingsDirty = true;
        if (this.detectorSettings == null) {
            this.detectorSettings = new DetectorSettingsI();
        }
        this.detectorSettings.setOffsetValue(rtypes.rdouble(value));
    }

    public void setDetectorSettingsGain(double value) {
        this.detectorSettingsDirty = true;
        if (this.detectorSettings == null) {
            this.detectorSettings = new DetectorSettingsI();
        }
        this.detectorSettings.setGain(rtypes.rdouble(value));
    }

    public void setDetectorSettingsReadOutRate(double value) {
        this.detectorSettingsDirty = true;
        if (this.detectorSettings == null) {
            this.detectorSettings = new DetectorSettingsI();
        }
        this.detectorSettings.setReadOutRate(rtypes.rdouble(value));
    }

    public void setDetectorSettingsVoltage(double value) {
        this.detectorSettingsDirty = true;
        if (this.detectorSettings == null) {
            this.detectorSettings = new DetectorSettingsI();
        }
        this.detectorSettings.setVoltage(rtypes.rdouble(value));
    }

    public void setDetectorSettingBinning(Binning binning) {
        this.binning = binning;
    }

    public Binning getDetectorBinningAsEnum() {
        return this.binning;
    }

    public boolean isDetectorSettingsDirty() {
        return this.detectorSettingsDirty;
    }

    public boolean isLightSourceSettingsDirty() {
        return this.ligthSourceSettingsDirty;
    }

    public LightSourceData getLightSource() {
        if (this.lightSettings == null) {
            return null;
        }
        if (this.ligthSource != null) {
            return this.ligthSource;
        }
        LightSource src = this.lightSettings.getLightSource();
        if (src != null) {
            this.ligthSource = new LightSourceData(src);
        }
        return this.ligthSource;
    }

    public void setLightSource(LightSourceData ligthSource) {
        this.ligthSource = ligthSource;
    }

    public LightPathData getLightPath() {
        return this.lightPath;
    }

    public FilterSetData getFilterSet() {
        return this.filterSet;
    }

    public String getIllumination() {
        LogicalChannel lc = (LogicalChannel)this.asIObject();
        if (lc == null) {
            return null;
        }
        Illumination value = lc.getIllumination();
        if (value != null) {
            return value.getValue().getValue();
        }
        return null;
    }

    public String getContrastMethod() {
        LogicalChannel lc = (LogicalChannel)this.asIObject();
        if (lc == null) {
            return null;
        }
        ContrastMethod value = lc.getContrastMethod();
        if (value != null) {
            return value.getValue().getValue();
        }
        return null;
    }

    public String getMode() {
        LogicalChannel lc = (LogicalChannel)this.asIObject();
        if (lc == null) {
            return null;
        }
        AcquisitionMode value = lc.getMode();
        if (value != null) {
            return value.getValue().getValue();
        }
        return null;
    }
}

