/*
 * Decompiled with CFR 0.152.
 */
package omerojava.util;

import omerojava.util.BytesConverter;
import omerojava.util.ReadOnlyByteArray;

public class Plane1D {
    private int bytesPerPixel;
    private int sizeX;
    private int sizeY;
    private ReadOnlyByteArray data;
    private BytesConverter strategy;

    private int calculateOffset(int x, int y) {
        return this.bytesPerPixel * (this.sizeX * y + x);
    }

    private double[] mappedDataAsDouble(int sizeY) {
        double[] mappedData = new double[this.sizeX * sizeY];
        for (int x = 0; x < this.sizeX; ++x) {
            for (int y = 0; y < sizeY; ++y) {
                int offset = this.calculateOffset(x, y);
                int index = this.sizeX * y + x;
                mappedData[index] = this.strategy.pack(this.data, offset, this.bytesPerPixel);
            }
        }
        return mappedData;
    }

    private long[] mappedDataAsLong(int sizeY) {
        long[] mappedData = new long[this.sizeX * sizeY];
        for (int x = 0; x < this.sizeX; ++x) {
            for (int y = 0; y < sizeY; ++y) {
                int offset = this.calculateOffset(x, y);
                int index = this.sizeX * y + x;
                mappedData[index] = (long)this.strategy.pack(this.data, offset, this.bytesPerPixel);
            }
        }
        return mappedData;
    }

    private int[] mappedDataAsInt(int sizeY) {
        int[] mappedData = new int[this.sizeX * sizeY];
        for (int x = 0; x < this.sizeX; ++x) {
            for (int y = 0; y < sizeY; ++y) {
                int offset = this.calculateOffset(x, y);
                int index = this.sizeX * y + x;
                mappedData[index] = (int)this.strategy.pack(this.data, offset, this.bytesPerPixel);
            }
        }
        return mappedData;
    }

    private short[] mappedDataAsShort(int sizeY) {
        short[] mappedData = new short[this.sizeX * sizeY];
        for (int x = 0; x < this.sizeX; ++x) {
            for (int y = 0; y < sizeY; ++y) {
                int offset = this.calculateOffset(x, y);
                int index = this.sizeX * y + x;
                mappedData[index] = (short)this.strategy.pack(this.data, offset, this.bytesPerPixel);
            }
        }
        return mappedData;
    }

    private byte[] mappedDataAsByte(int sizeY) {
        byte[] mappedData = new byte[this.sizeX * sizeY];
        for (int x = 0; x < this.sizeX; ++x) {
            for (int y = 0; y < sizeY; ++y) {
                int offset = this.calculateOffset(x, y);
                int index = this.sizeX * y + x;
                mappedData[index] = (byte)this.strategy.pack(this.data, offset, this.bytesPerPixel);
            }
        }
        return mappedData;
    }

    public Plane1D(ReadOnlyByteArray data, int sizeX, int sizeY, int bytesPerPixel, BytesConverter strategy) {
        this.bytesPerPixel = bytesPerPixel;
        this.data = data;
        this.strategy = strategy;
        this.sizeX = sizeX;
        this.sizeY = sizeY;
    }

    public double[] getPixelsArrayAsDouble() {
        return this.mappedDataAsDouble(this.sizeY);
    }

    public long[] getPixelsArrayAsLong() {
        return this.mappedDataAsLong(this.sizeY);
    }

    public int[] getPixelsArrayAsInt() {
        return this.mappedDataAsInt(this.sizeY);
    }

    public short[] getPixelsArrayAsShort() {
        return this.mappedDataAsShort(this.sizeY);
    }

    public byte[] getPixelsArrayAsByte() {
        return this.mappedDataAsByte(this.sizeY);
    }
}

