/*
 * Decompiled with CFR 0.152.
 */
package omerojava.util;

import java.util.LinkedHashMap;
import java.util.Map;
import omerojava.util.Plane2D;

public class PixelsCache {
    private int cacheSize;
    private int planeSize;
    private int maxEntries;
    private Map<Integer, Plane2D> cache;

    private void ensureCapacity(Integer p) {
        Integer[] orderedCache = this.cache.keySet().toArray(new Integer[0]);
        Integer candidate = orderedCache[0];
        this.cache.remove(candidate);
    }

    public PixelsCache(int cacheSize, int planeSize) {
        if (cacheSize <= 0) {
            throw new IllegalArgumentException("Cache size must be positive: " + cacheSize + ".");
        }
        if (planeSize <= 0) {
            throw new IllegalArgumentException("Image size must be positive: " + planeSize + ".");
        }
        this.cacheSize = cacheSize;
        this.planeSize = planeSize;
        this.maxEntries = cacheSize / planeSize;
        this.cache = new LinkedHashMap<Integer, Plane2D>(this.maxEntries);
    }

    void add(Integer planeIndex, Plane2D data) {
        if (this.maxEntries == 0) {
            return;
        }
        if (planeIndex == null || planeIndex < 0) {
            throw new IllegalArgumentException("Plane index not valid.");
        }
        if (data == null) {
            throw new NullPointerException("No data.");
        }
        if (this.maxEntries <= this.cache.size()) {
            this.ensureCapacity(planeIndex);
        }
        this.cache.put(planeIndex, data);
    }

    Plane2D extract(Integer planeIndex) {
        if (planeIndex == null || planeIndex < 0) {
            throw new IllegalArgumentException("Plane index not valid.");
        }
        return this.cache.get(planeIndex);
    }

    boolean contains(Integer planeIndex) {
        if (planeIndex == null || planeIndex < 0) {
            return false;
        }
        return this.cache.get(planeIndex) != null;
    }

    void clear() {
        int oldSize = this.cache.size();
        this.cache = new LinkedHashMap<Integer, Plane2D>(oldSize);
    }

    public void resetCacheSize(int size) {
        if (size < 0) {
            throw new IllegalArgumentException("Cache size must be positive: " + size + ".");
        }
        this.cacheSize = size;
        this.maxEntries = this.cacheSize / this.planeSize;
        this.cache = new LinkedHashMap<Integer, Plane2D>(this.maxEntries);
    }
}

