/*
 * Decompiled with CFR 0.152.
 */
package omerojava.util;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import omero.ServerError;
import omero.api.GatewayPrx;

public class GatewayHeartbeat {
    private GatewayPrx gateway;
    private HeartBeatService heartbeatService;

    public GatewayHeartbeat(GatewayPrx gateway) {
        this.gateway = gateway;
        this.heartbeatService = new HeartBeatService();
    }

    public void Stop() throws ServerError {
        this.heartbeatService.scheduler.shutdown();
        this.gateway.close();
    }

    public void Start() throws ServerError {
        this.heartbeatService.start();
    }

    class HeartBeatService {
        private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);

        HeartBeatService() {
        }

        public void start() {
            Runnable beat = new Runnable(){

                public void run() {
                    try {
                        GatewayHeartbeat.this.gateway.keepAlive();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            };
            ScheduledFuture<?> beatHandle = this.scheduler.scheduleAtFixedRate(beat, 10L, 10L, TimeUnit.SECONDS);
        }
    }
}

