/*
 * Decompiled with CFR 0.152.
 */
package omero.util;

import omero.ServerError;
import omero.api.RawPixelsStorePrx;
import omero.model.Pixels;
import omero.util.RPSTileLoop;
import omero.util.TileData;

public class RPSTileData
implements TileData {
    protected final RawPixelsStorePrx rps;
    protected final RPSTileLoop loop;

    public RPSTileData(RPSTileLoop loop, RawPixelsStorePrx rps) {
        this.loop = loop;
        this.rps = rps;
    }

    public byte[] getTile(int z, int c, int t, int x, int y, int w, int h) {
        try {
            return this.rps.getTile(z, c, t, x, y, w, h);
        }
        catch (ServerError se) {
            throw new RuntimeException(se);
        }
    }

    public void setTile(byte[] buffer, int z, int c, int t, int x, int y, int w, int h) {
        try {
            this.rps.setTile(buffer, z, c, t, x, y, w, h);
        }
        catch (ServerError se) {
            throw new RuntimeException(se);
        }
    }

    public void close() {
        try {
            Pixels pixels = this.rps.save();
            this.loop.setPixels(pixels);
            this.rps.close();
        }
        catch (ServerError se) {
            throw new RuntimeException(se);
        }
    }
}

