/*
 * Decompiled with CFR 0.152.
 */
package omero.model;

import java.awt.Shape;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import omero.model.LabelI;
import omero.model.Point;
import omero.model.PointI;
import omero.model.SmartShape;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SmartTextI
extends LabelI
implements SmartShape {
    @Override
    public void areaPoints(SmartShape.PointCallback cb) {
        try {
            cb.handle((int)this.x.getValue(), (int)this.y.getValue());
        }
        catch (NullPointerException npe) {
            return;
        }
    }

    @Override
    public Shape asAwtShape() {
        List<Point> points = this.asPoints();
        if (points == null) {
            return null;
        }
        String path = SmartShape.Util.pointsToPath(points, true);
        return SmartShape.Util.parseAwtPath(path);
    }

    @Override
    public List<Point> asPoints() {
        if (this.x == null || this.y == null) {
            return null;
        }
        PointI pt = new PointI();
        pt.cx = this.x;
        pt.cy = this.y;
        List<Point> points = Arrays.asList(pt);
        assert (SmartShape.Util.checkNonNull(points)) : "Null points in " + this;
        return points;
    }

    @Override
    public void randomize(Random random) {
        if (this.roi != null) {
            throw new UnsupportedOperationException("Roi-based values unsupported");
        }
    }
}

