/*
 * Decompiled with CFR 0.152.
 */
package omero.model;

import java.awt.Shape;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import omero.model.Point;
import omero.model.PointI;
import omero.model.SmartShape;
import omero.rtypes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SmartPointI
extends PointI
implements SmartShape {
    @Override
    public void areaPoints(SmartShape.PointCallback cb) {
        try {
            cb.handle((int)this.cx.getValue(), (int)this.cy.getValue());
        }
        catch (NullPointerException npe) {
            return;
        }
    }

    @Override
    public Shape asAwtShape() {
        List<Point> points = this.asPoints();
        if (points == null) {
            return null;
        }
        String path = SmartShape.Util.pointsToPath(points, true);
        return SmartShape.Util.parseAwtPath(path);
    }

    @Override
    public List<Point> asPoints() {
        if (this.cx == null || this.cy == null) {
            return null;
        }
        List<Point> points = Arrays.asList(this);
        assert (SmartShape.Util.checkNonNull(points)) : "Null points in " + this;
        return points;
    }

    @Override
    public void randomize(Random random) {
        if (this.roi != null) {
            throw new UnsupportedOperationException("Roi-based values unsupported");
        }
        this.cx = rtypes.rdouble(random.nextInt(100));
        this.cy = rtypes.rdouble(random.nextInt(100));
    }
}

