/*
 * Decompiled with CFR 0.152.
 */
package omero.model;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import omero.model.EllipseI;
import omero.model.Point;
import omero.model.SmartPointI;
import omero.model.SmartShape;
import omero.rtypes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SmartEllipseI
extends EllipseI
implements SmartShape {
    @Override
    public void areaPoints(SmartShape.PointCallback cb) {
        Shape s = this.asAwtShape();
        if (s == null) {
            return;
        }
        Rectangle2D r = s.getBounds2D();
        SmartShape.Util.pointsByBoundingBox(s, r, cb);
    }

    @Override
    public Shape asAwtShape() {
        try {
            double cx = this.getCx().getValue();
            double cy = this.getCy().getValue();
            double rx = this.getRx().getValue();
            double ry = this.getRy().getValue();
            double height = ry * 2.0;
            double width = rx * 2.0;
            double cornerX = cx - rx;
            double cornerY = cy - ry;
            Ellipse2D.Double e = new Ellipse2D.Double(cornerX, cornerY, width, height);
            return e;
        }
        catch (NullPointerException npe) {
            return null;
        }
    }

    @Override
    public List<Point> asPoints() {
        Ellipse2D.Double e2d = (Ellipse2D.Double)this.asAwtShape();
        if (e2d == null) {
            return null;
        }
        PathIterator it = e2d.getPathIterator(new AffineTransform(), 0.1f);
        ArrayList<Point> points = new ArrayList<Point>();
        double[] coords = new double[6];
        while (!it.isDone()) {
            it.currentSegment(coords);
            SmartPointI pt = new SmartPointI();
            pt.setCx(rtypes.rdouble(coords[0]));
            pt.setCy(rtypes.rdouble(coords[1]));
            points.add(pt);
            it.next();
        }
        assert (SmartShape.Util.checkNonNull(points)) : "Null points in " + this;
        return points;
    }

    @Override
    public void randomize(Random random) {
        if (this.roi != null) {
            throw new UnsupportedOperationException("Roi-based values unsupported");
        }
        this.cx = rtypes.rdouble(random.nextInt(100));
        this.cy = rtypes.rdouble(random.nextInt(100));
        this.rx = rtypes.rdouble(random.nextInt(100));
        this.ry = rtypes.rdouble(random.nextInt(100));
    }
}

