/*
 * Decompiled with CFR 0.152.
 */
package omero.model;

import Ice.Current;
import Ice.DispatchStatus;
import Ice.InputStream;
import Ice.MarshalException;
import Ice.OperationMode;
import Ice.OperationNotExistException;
import Ice.OutputStream;
import IceInternal.BasicStream;
import IceInternal.Ex;
import IceInternal.Incoming;
import java.util.Arrays;
import omero.RBool;
import omero.RBoolHolder;
import omero.RDouble;
import omero.RDoubleHolder;
import omero.RInt;
import omero.RIntHolder;
import omero.RLong;
import omero.RString;
import omero.model.Details;
import omero.model.IObject;
import omero.model.Instrument;
import omero.model.LaserMedium;
import omero.model.LaserMediumHolder;
import omero.model.LaserType;
import omero.model.LaserTypeHolder;
import omero.model.LightSource;
import omero.model.LightSourceHolder;
import omero.model.Pulse;
import omero.model.PulseHolder;
import omero.model._LaserOperations;
import omero.model._LaserOperationsNC;

public abstract class Laser
extends LightSource
implements _LaserOperations,
_LaserOperationsNC {
    public static final String[] __ids = new String[]{"::Ice::Object", "::omero::model::IObject", "::omero::model::Laser", "::omero::model::LightSource"};
    private static final String[] __all = new String[]{"getDetails", "getFrequencyMultiplication", "getId", "getInstrument", "getLaserMedium", "getLotNumber", "getManufacturer", "getModel", "getPockelCell", "getPower", "getPulse", "getPump", "getRepetitionRate", "getSerialNumber", "getTuneable", "getType", "getVersion", "getWavelength", "ice_id", "ice_ids", "ice_isA", "ice_ping", "isAnnotated", "isGlobal", "isLink", "isLoaded", "isMutable", "proxy", "setFrequencyMultiplication", "setId", "setInstrument", "setLaserMedium", "setLotNumber", "setManufacturer", "setModel", "setPockelCell", "setPower", "setPulse", "setPump", "setRepetitionRate", "setSerialNumber", "setTuneable", "setType", "setVersion", "setWavelength", "shallowCopy", "unload", "unloadCollections", "unloadDetails"};
    protected LaserType type;
    protected LaserMedium laserMedium;
    protected RInt frequencyMultiplication;
    protected RBool tuneable;
    protected Pulse pulse;
    protected RInt wavelength;
    protected RBool pockelCell;
    protected LightSource pump;
    protected RDouble repetitionRate;

    public Laser() {
    }

    public Laser(RLong id, Details details, boolean loaded, RInt version, RString manufacturer, RString model, RDouble power, RString lotNumber, RString serialNumber, Instrument instrument, LaserType type, LaserMedium laserMedium, RInt frequencyMultiplication, RBool tuneable, Pulse pulse, RInt wavelength, RBool pockelCell, LightSource pump, RDouble repetitionRate) {
        super(id, details, loaded, version, manufacturer, model, power, lotNumber, serialNumber, instrument);
        this.type = type;
        this.laserMedium = laserMedium;
        this.frequencyMultiplication = frequencyMultiplication;
        this.tuneable = tuneable;
        this.pulse = pulse;
        this.wavelength = wavelength;
        this.pockelCell = pockelCell;
        this.pump = pump;
        this.repetitionRate = repetitionRate;
    }

    public boolean ice_isA(String s) {
        return Arrays.binarySearch(__ids, s) >= 0;
    }

    public boolean ice_isA(String s, Current __current) {
        return Arrays.binarySearch(__ids, s) >= 0;
    }

    public String[] ice_ids() {
        return __ids;
    }

    public String[] ice_ids(Current __current) {
        return __ids;
    }

    public String ice_id() {
        return __ids[2];
    }

    public String ice_id(Current __current) {
        return __ids[2];
    }

    public static String ice_staticId() {
        return __ids[2];
    }

    public final RInt getFrequencyMultiplication() {
        return this.getFrequencyMultiplication(null);
    }

    public final LaserMedium getLaserMedium() {
        return this.getLaserMedium(null);
    }

    public final RBool getPockelCell() {
        return this.getPockelCell(null);
    }

    public final Pulse getPulse() {
        return this.getPulse(null);
    }

    public final LightSource getPump() {
        return this.getPump(null);
    }

    public final RDouble getRepetitionRate() {
        return this.getRepetitionRate(null);
    }

    public final RBool getTuneable() {
        return this.getTuneable(null);
    }

    public final LaserType getType() {
        return this.getType(null);
    }

    public final RInt getWavelength() {
        return this.getWavelength(null);
    }

    public final void setFrequencyMultiplication(RInt theFrequencyMultiplication) {
        this.setFrequencyMultiplication(theFrequencyMultiplication, null);
    }

    public final void setLaserMedium(LaserMedium theLaserMedium) {
        this.setLaserMedium(theLaserMedium, null);
    }

    public final void setPockelCell(RBool thePockelCell) {
        this.setPockelCell(thePockelCell, null);
    }

    public final void setPulse(Pulse thePulse) {
        this.setPulse(thePulse, null);
    }

    public final void setPump(LightSource thePump) {
        this.setPump(thePump, null);
    }

    public final void setRepetitionRate(RDouble theRepetitionRate) {
        this.setRepetitionRate(theRepetitionRate, null);
    }

    public final void setTuneable(RBool theTuneable) {
        this.setTuneable(theTuneable, null);
    }

    public final void setType(LaserType theType) {
        this.setType(theType, null);
    }

    public final void setWavelength(RInt theWavelength) {
        this.setWavelength(theWavelength, null);
    }

    public static DispatchStatus ___getType(Laser __obj, Incoming __inS, Current __current) {
        Laser.__checkMode(OperationMode.Normal, __current.mode);
        __inS.is().skipEmptyEncaps();
        BasicStream __os = __inS.os();
        LaserType __ret = __obj.getType(__current);
        __os.writeObject(__ret);
        __os.writePendingObjects();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___setType(Laser __obj, Incoming __inS, Current __current) {
        Laser.__checkMode(OperationMode.Normal, __current.mode);
        BasicStream __is = __inS.is();
        __is.startReadEncaps();
        LaserTypeHolder theType = new LaserTypeHolder();
        __is.readObject(theType.getPatcher());
        __is.readPendingObjects();
        __is.endReadEncaps();
        __obj.setType(theType.value, __current);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___getLaserMedium(Laser __obj, Incoming __inS, Current __current) {
        Laser.__checkMode(OperationMode.Normal, __current.mode);
        __inS.is().skipEmptyEncaps();
        BasicStream __os = __inS.os();
        LaserMedium __ret = __obj.getLaserMedium(__current);
        __os.writeObject(__ret);
        __os.writePendingObjects();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___setLaserMedium(Laser __obj, Incoming __inS, Current __current) {
        Laser.__checkMode(OperationMode.Normal, __current.mode);
        BasicStream __is = __inS.is();
        __is.startReadEncaps();
        LaserMediumHolder theLaserMedium = new LaserMediumHolder();
        __is.readObject(theLaserMedium.getPatcher());
        __is.readPendingObjects();
        __is.endReadEncaps();
        __obj.setLaserMedium(theLaserMedium.value, __current);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___getFrequencyMultiplication(Laser __obj, Incoming __inS, Current __current) {
        Laser.__checkMode(OperationMode.Normal, __current.mode);
        __inS.is().skipEmptyEncaps();
        BasicStream __os = __inS.os();
        RInt __ret = __obj.getFrequencyMultiplication(__current);
        __os.writeObject(__ret);
        __os.writePendingObjects();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___setFrequencyMultiplication(Laser __obj, Incoming __inS, Current __current) {
        Laser.__checkMode(OperationMode.Normal, __current.mode);
        BasicStream __is = __inS.is();
        __is.startReadEncaps();
        RIntHolder theFrequencyMultiplication = new RIntHolder();
        __is.readObject(theFrequencyMultiplication.getPatcher());
        __is.readPendingObjects();
        __is.endReadEncaps();
        __obj.setFrequencyMultiplication(theFrequencyMultiplication.value, __current);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___getTuneable(Laser __obj, Incoming __inS, Current __current) {
        Laser.__checkMode(OperationMode.Normal, __current.mode);
        __inS.is().skipEmptyEncaps();
        BasicStream __os = __inS.os();
        RBool __ret = __obj.getTuneable(__current);
        __os.writeObject(__ret);
        __os.writePendingObjects();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___setTuneable(Laser __obj, Incoming __inS, Current __current) {
        Laser.__checkMode(OperationMode.Normal, __current.mode);
        BasicStream __is = __inS.is();
        __is.startReadEncaps();
        RBoolHolder theTuneable = new RBoolHolder();
        __is.readObject(theTuneable.getPatcher());
        __is.readPendingObjects();
        __is.endReadEncaps();
        __obj.setTuneable(theTuneable.value, __current);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___getPulse(Laser __obj, Incoming __inS, Current __current) {
        Laser.__checkMode(OperationMode.Normal, __current.mode);
        __inS.is().skipEmptyEncaps();
        BasicStream __os = __inS.os();
        Pulse __ret = __obj.getPulse(__current);
        __os.writeObject(__ret);
        __os.writePendingObjects();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___setPulse(Laser __obj, Incoming __inS, Current __current) {
        Laser.__checkMode(OperationMode.Normal, __current.mode);
        BasicStream __is = __inS.is();
        __is.startReadEncaps();
        PulseHolder thePulse = new PulseHolder();
        __is.readObject(thePulse.getPatcher());
        __is.readPendingObjects();
        __is.endReadEncaps();
        __obj.setPulse(thePulse.value, __current);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___getWavelength(Laser __obj, Incoming __inS, Current __current) {
        Laser.__checkMode(OperationMode.Normal, __current.mode);
        __inS.is().skipEmptyEncaps();
        BasicStream __os = __inS.os();
        RInt __ret = __obj.getWavelength(__current);
        __os.writeObject(__ret);
        __os.writePendingObjects();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___setWavelength(Laser __obj, Incoming __inS, Current __current) {
        Laser.__checkMode(OperationMode.Normal, __current.mode);
        BasicStream __is = __inS.is();
        __is.startReadEncaps();
        RIntHolder theWavelength = new RIntHolder();
        __is.readObject(theWavelength.getPatcher());
        __is.readPendingObjects();
        __is.endReadEncaps();
        __obj.setWavelength(theWavelength.value, __current);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___getPockelCell(Laser __obj, Incoming __inS, Current __current) {
        Laser.__checkMode(OperationMode.Normal, __current.mode);
        __inS.is().skipEmptyEncaps();
        BasicStream __os = __inS.os();
        RBool __ret = __obj.getPockelCell(__current);
        __os.writeObject(__ret);
        __os.writePendingObjects();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___setPockelCell(Laser __obj, Incoming __inS, Current __current) {
        Laser.__checkMode(OperationMode.Normal, __current.mode);
        BasicStream __is = __inS.is();
        __is.startReadEncaps();
        RBoolHolder thePockelCell = new RBoolHolder();
        __is.readObject(thePockelCell.getPatcher());
        __is.readPendingObjects();
        __is.endReadEncaps();
        __obj.setPockelCell(thePockelCell.value, __current);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___getPump(Laser __obj, Incoming __inS, Current __current) {
        Laser.__checkMode(OperationMode.Normal, __current.mode);
        __inS.is().skipEmptyEncaps();
        BasicStream __os = __inS.os();
        LightSource __ret = __obj.getPump(__current);
        __os.writeObject(__ret);
        __os.writePendingObjects();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___setPump(Laser __obj, Incoming __inS, Current __current) {
        Laser.__checkMode(OperationMode.Normal, __current.mode);
        BasicStream __is = __inS.is();
        __is.startReadEncaps();
        LightSourceHolder thePump = new LightSourceHolder();
        __is.readObject(thePump.getPatcher());
        __is.readPendingObjects();
        __is.endReadEncaps();
        __obj.setPump(thePump.value, __current);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___getRepetitionRate(Laser __obj, Incoming __inS, Current __current) {
        Laser.__checkMode(OperationMode.Normal, __current.mode);
        __inS.is().skipEmptyEncaps();
        BasicStream __os = __inS.os();
        RDouble __ret = __obj.getRepetitionRate(__current);
        __os.writeObject(__ret);
        __os.writePendingObjects();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___setRepetitionRate(Laser __obj, Incoming __inS, Current __current) {
        Laser.__checkMode(OperationMode.Normal, __current.mode);
        BasicStream __is = __inS.is();
        __is.startReadEncaps();
        RDoubleHolder theRepetitionRate = new RDoubleHolder();
        __is.readObject(theRepetitionRate.getPatcher());
        __is.readPendingObjects();
        __is.endReadEncaps();
        __obj.setRepetitionRate(theRepetitionRate.value, __current);
        return DispatchStatus.DispatchOK;
    }

    public DispatchStatus __dispatch(Incoming in, Current __current) {
        int pos = Arrays.binarySearch(__all, __current.operation);
        if (pos < 0) {
            throw new OperationNotExistException(__current.id, __current.facet, __current.operation);
        }
        switch (pos) {
            case 0: {
                return IObject.___getDetails(this, in, __current);
            }
            case 1: {
                return Laser.___getFrequencyMultiplication(this, in, __current);
            }
            case 2: {
                return IObject.___getId(this, in, __current);
            }
            case 3: {
                return LightSource.___getInstrument(this, in, __current);
            }
            case 4: {
                return Laser.___getLaserMedium(this, in, __current);
            }
            case 5: {
                return LightSource.___getLotNumber(this, in, __current);
            }
            case 6: {
                return LightSource.___getManufacturer(this, in, __current);
            }
            case 7: {
                return LightSource.___getModel(this, in, __current);
            }
            case 8: {
                return Laser.___getPockelCell(this, in, __current);
            }
            case 9: {
                return LightSource.___getPower(this, in, __current);
            }
            case 10: {
                return Laser.___getPulse(this, in, __current);
            }
            case 11: {
                return Laser.___getPump(this, in, __current);
            }
            case 12: {
                return Laser.___getRepetitionRate(this, in, __current);
            }
            case 13: {
                return LightSource.___getSerialNumber(this, in, __current);
            }
            case 14: {
                return Laser.___getTuneable(this, in, __current);
            }
            case 15: {
                return Laser.___getType(this, in, __current);
            }
            case 16: {
                return LightSource.___getVersion(this, in, __current);
            }
            case 17: {
                return Laser.___getWavelength(this, in, __current);
            }
            case 18: {
                return Laser.___ice_id(this, in, __current);
            }
            case 19: {
                return Laser.___ice_ids(this, in, __current);
            }
            case 20: {
                return Laser.___ice_isA(this, in, __current);
            }
            case 21: {
                return Laser.___ice_ping(this, in, __current);
            }
            case 22: {
                return IObject.___isAnnotated(this, in, __current);
            }
            case 23: {
                return IObject.___isGlobal(this, in, __current);
            }
            case 24: {
                return IObject.___isLink(this, in, __current);
            }
            case 25: {
                return IObject.___isLoaded(this, in, __current);
            }
            case 26: {
                return IObject.___isMutable(this, in, __current);
            }
            case 27: {
                return IObject.___proxy(this, in, __current);
            }
            case 28: {
                return Laser.___setFrequencyMultiplication(this, in, __current);
            }
            case 29: {
                return IObject.___setId(this, in, __current);
            }
            case 30: {
                return LightSource.___setInstrument(this, in, __current);
            }
            case 31: {
                return Laser.___setLaserMedium(this, in, __current);
            }
            case 32: {
                return LightSource.___setLotNumber(this, in, __current);
            }
            case 33: {
                return LightSource.___setManufacturer(this, in, __current);
            }
            case 34: {
                return LightSource.___setModel(this, in, __current);
            }
            case 35: {
                return Laser.___setPockelCell(this, in, __current);
            }
            case 36: {
                return LightSource.___setPower(this, in, __current);
            }
            case 37: {
                return Laser.___setPulse(this, in, __current);
            }
            case 38: {
                return Laser.___setPump(this, in, __current);
            }
            case 39: {
                return Laser.___setRepetitionRate(this, in, __current);
            }
            case 40: {
                return LightSource.___setSerialNumber(this, in, __current);
            }
            case 41: {
                return Laser.___setTuneable(this, in, __current);
            }
            case 42: {
                return Laser.___setType(this, in, __current);
            }
            case 43: {
                return LightSource.___setVersion(this, in, __current);
            }
            case 44: {
                return Laser.___setWavelength(this, in, __current);
            }
            case 45: {
                return IObject.___shallowCopy(this, in, __current);
            }
            case 46: {
                return IObject.___unload(this, in, __current);
            }
            case 47: {
                return IObject.___unloadCollections(this, in, __current);
            }
            case 48: {
                return IObject.___unloadDetails(this, in, __current);
            }
        }
        assert (false);
        throw new OperationNotExistException(__current.id, __current.facet, __current.operation);
    }

    public void __write(BasicStream __os) {
        __os.writeTypeId(Laser.ice_staticId());
        __os.startWriteSlice();
        __os.writeObject(this.type);
        __os.writeObject(this.laserMedium);
        __os.writeObject(this.frequencyMultiplication);
        __os.writeObject(this.tuneable);
        __os.writeObject(this.pulse);
        __os.writeObject(this.wavelength);
        __os.writeObject(this.pockelCell);
        __os.writeObject(this.pump);
        __os.writeObject(this.repetitionRate);
        __os.endWriteSlice();
        super.__write(__os);
    }

    public void __read(BasicStream __is, boolean __rid) {
        if (__rid) {
            __is.readTypeId();
        }
        __is.startReadSlice();
        __is.readObject(new Patcher(9));
        __is.readObject(new Patcher(10));
        __is.readObject(new Patcher(11));
        __is.readObject(new Patcher(12));
        __is.readObject(new Patcher(13));
        __is.readObject(new Patcher(14));
        __is.readObject(new Patcher(15));
        __is.readObject(new Patcher(16));
        __is.readObject(new Patcher(17));
        __is.endReadSlice();
        super.__read(__is, true);
    }

    public void __write(OutputStream __outS) {
        MarshalException ex = new MarshalException();
        ex.reason = "type omero::model::Laser was not generated with stream support";
        throw ex;
    }

    public void __read(InputStream __inS, boolean __rid) {
        MarshalException ex = new MarshalException();
        ex.reason = "type omero::model::Laser was not generated with stream support";
        throw ex;
    }

    private class Patcher
    implements IceInternal.Patcher {
        private int __member;
        private String __typeId;

        Patcher(int member) {
            this.__member = member;
        }

        public void patch(Ice.Object v) {
            try {
                switch (this.__member) {
                    case 0: {
                        this.__typeId = "::omero::RLong";
                        Laser.this.id = (RLong)v;
                        break;
                    }
                    case 1: {
                        this.__typeId = "::omero::model::Details";
                        Laser.this.details = (Details)v;
                        break;
                    }
                    case 2: {
                        this.__typeId = "::omero::RInt";
                        Laser.this.version = (RInt)v;
                        break;
                    }
                    case 3: {
                        this.__typeId = "::omero::RString";
                        Laser.this.manufacturer = (RString)v;
                        break;
                    }
                    case 4: {
                        this.__typeId = "::omero::RString";
                        Laser.this.model = (RString)v;
                        break;
                    }
                    case 5: {
                        this.__typeId = "::omero::RDouble";
                        Laser.this.power = (RDouble)v;
                        break;
                    }
                    case 6: {
                        this.__typeId = "::omero::RString";
                        Laser.this.lotNumber = (RString)v;
                        break;
                    }
                    case 7: {
                        this.__typeId = "::omero::RString";
                        Laser.this.serialNumber = (RString)v;
                        break;
                    }
                    case 8: {
                        this.__typeId = "::omero::model::Instrument";
                        Laser.this.instrument = (Instrument)v;
                        break;
                    }
                    case 9: {
                        this.__typeId = "::omero::model::LaserType";
                        Laser.this.type = (LaserType)v;
                        break;
                    }
                    case 10: {
                        this.__typeId = "::omero::model::LaserMedium";
                        Laser.this.laserMedium = (LaserMedium)v;
                        break;
                    }
                    case 11: {
                        this.__typeId = "::omero::RInt";
                        Laser.this.frequencyMultiplication = (RInt)v;
                        break;
                    }
                    case 12: {
                        this.__typeId = "::omero::RBool";
                        Laser.this.tuneable = (RBool)v;
                        break;
                    }
                    case 13: {
                        this.__typeId = "::omero::model::Pulse";
                        Laser.this.pulse = (Pulse)v;
                        break;
                    }
                    case 14: {
                        this.__typeId = "::omero::RInt";
                        Laser.this.wavelength = (RInt)v;
                        break;
                    }
                    case 15: {
                        this.__typeId = "::omero::RBool";
                        Laser.this.pockelCell = (RBool)v;
                        break;
                    }
                    case 16: {
                        this.__typeId = "::omero::model::LightSource";
                        Laser.this.pump = (LightSource)v;
                        break;
                    }
                    case 17: {
                        this.__typeId = "::omero::RDouble";
                        Laser.this.repetitionRate = (RDouble)v;
                    }
                }
            }
            catch (ClassCastException ex) {
                Ex.throwUOE(this.type(), v.ice_id());
            }
        }

        public String type() {
            return this.__typeId;
        }
    }
}

