/*
 * Decompiled with CFR 0.152.
 */
package omero.grid;

import Glacier2.SessionControlPrx;
import Ice.Current;
import Ice.Identity;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import ome.api.JobHandle;
import ome.api.RawFileStore;
import ome.model.core.OriginalFile;
import ome.model.meta.Session;
import ome.parameters.Parameters;
import ome.services.blitz.impl.CloseableServant;
import ome.services.sessions.SessionManager;
import ome.services.util.Executor;
import ome.system.EventContext;
import ome.system.Principal;
import ome.system.ServiceFactory;
import omero.ApiUsageException;
import omero.InternalException;
import omero.RMap;
import omero.RType;
import omero.ServerError;
import omero.ValidationException;
import omero.grid.JobParams;
import omero.grid.ParamsHelper;
import omero.grid.ProcessPrx;
import omero.grid.ProcessPrxHelper;
import omero.grid.ProcessorPrx;
import omero.grid._InteractiveProcessorDisp;
import omero.model.Job;
import omero.model.OriginalFileI;
import omero.model.ParseJob;
import omero.rtypes;
import omero.util.IceMapper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.transaction.annotation.Transactional;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InteractiveProcessorI
extends _InteractiveProcessorDisp
implements CloseableServant {
    private static Session UNINITIALIZED = new Session();
    private static Log log = LogFactory.getLog(InteractiveProcessorI.class);
    private final SessionManager mgr;
    private final ProcessorPrx prx;
    private final ParamsHelper helper;
    private final Executor ex;
    private final Job job;
    private final long scriptId;
    private final long timeout;
    private final ReadWriteLock rwl = new ReentrantReadWriteLock();
    private final Principal principal;
    private final SessionControlPrx control;
    private boolean detach = false;
    private boolean obtainResults = false;
    private boolean stop = false;
    private ProcessPrx currentProcess = null;
    private Session session;
    private JobParams params;
    private static final String stdfile_query = "select file from Job job join job.originalFileLinks links join links.child file where file.name = :name and job.id = :id";
    private String getScriptIdQuery = "select f from Job s join s.originalFileLinks links join links.child f where s.id = :id and f.mimetype = :fmt";

    public InteractiveProcessorI(Principal p, SessionManager mgr, Executor ex, ProcessorPrx prx, Job job, long timeout, SessionControlPrx control, ParamsHelper helper) throws ServerError {
        this.helper = helper;
        this.principal = p;
        this.ex = ex;
        this.mgr = mgr;
        this.prx = prx;
        this.job = job;
        this.timeout = timeout;
        this.control = control;
        this.session = UNINITIALIZED;
        this.scriptId = this.getScriptId(job);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JobParams params(Current __current) throws ServerError {
        this.rwl.writeLock().lock();
        try {
            if (this.stop) {
                throw new ApiUsageException(null, null, "This processor is stopped.");
            }
            if (this.session == UNINITIALIZED) {
                this.session = this.newSession(__current);
            }
            if (this.params == null) {
                try {
                    if (this.job instanceof ParseJob) {
                        this.params = this.prx.parseJob(this.session.getUuid(), this.job);
                        if (this.params == null) {
                            StringBuilder sb = new StringBuilder();
                            sb.append("Can't find params for " + this.scriptId);
                            OriginalFile file = this.loadFileOrNull("stderr");
                            if (file == null) {
                                sb.append(". No stderr");
                            } else {
                                sb.append(". Stderr is in file " + file.getId());
                                this.appendIfText(file, sb);
                            }
                            throw new ValidationException(null, null, sb.toString());
                        }
                        this.helper.saveScriptParams(this.params, (ParseJob)this.job, __current);
                    } else {
                        this.params = this.helper.getOrCreateParams(this.scriptId, __current);
                    }
                }
                catch (Throwable t) {
                    if (t instanceof ServerError) {
                        log.debug((Object)"Error while parsing job", t);
                        throw (ServerError)t;
                    }
                    InternalException ie = new InternalException();
                    IceMapper.fillServerError(ie, t);
                    throw ie;
                }
            }
            JobParams jobParams = this.params;
            return jobParams;
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProcessPrx execute(RMap inputs, Current __current) throws ServerError {
        this.rwl.writeLock().lock();
        try {
            ProcessPrx processPrx;
            if (this.currentProcess != null) {
                throw new ApiUsageException(null, null, "Process currently running.");
            }
            if (this.obtainResults) {
                throw new ApiUsageException(null, null, "Please retrieve results.");
            }
            if (this.stop) {
                throw new ApiUsageException(null, null, "This processor is stopped.");
            }
            if (this.session == UNINITIALIZED) {
                this.session = this.newSession(__current);
            }
            if (inputs != null && inputs.getValue() != null) {
                IceMapper mapper = new IceMapper();
                for (String key : inputs.getValue().keySet()) {
                    Object v = mapper.fromRType(inputs.get(key));
                    this.mgr.setInput(this.session.getUuid(), key, v);
                }
            }
            try {
                String uuid = this.session.getUuid();
                if (this.params == null) {
                    this.params = this.params(__current);
                }
                this.currentProcess = this.prx.processJob(uuid, this.params, this.job);
                this.control.identities().add(new Identity[]{this.currentProcess.ice_getIdentity()});
            }
            catch (ValidationException ve) {
                this.failJob(ve);
                throw ve;
            }
            catch (ServerError se) {
                log.debug((Object)"Error while processing job", (Throwable)se);
                throw se;
            }
            if (this.currentProcess == null) {
                processPrx = null;
                return processPrx;
            }
            this.obtainResults = true;
            processPrx = this.currentProcess;
            return processPrx;
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RMap getResults(ProcessPrx proc, Current __current) throws ServerError {
        this.rwl.writeLock().lock();
        try {
            this.finishedOrThrow();
            RMap output = rtypes.rmap(new HashMap<String, RType>());
            Map env = this.mgr.outputEnvironment(this.session.getUuid());
            IceMapper mapper = new IceMapper();
            for (String key : env.keySet()) {
                RType rt = mapper.toRType(env.get(key));
                output.put(key, rt);
            }
            this.optionallyLoadFile(output.getValue(), "stdout");
            this.optionallyLoadFile(output.getValue(), "stderr");
            this.currentProcess = null;
            this.obtainResults = false;
            RMap rMap = output;
            return rMap;
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }

    @Override
    public long expires(Current __current) {
        return this.timeout;
    }

    @Override
    public Job getJob(Current __current) {
        return this.job;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setDetach(boolean detach, Current __current) {
        this.rwl.writeLock().lock();
        try {
            boolean old = this.detach;
            this.detach = detach;
            boolean bl = old;
            return bl;
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop(Current __current) throws ServerError {
        this.rwl.writeLock().lock();
        if (this.stop) {
            return;
        }
        try {
            if (this.detach) {
                if (this.currentProcess != null) {
                    log.info((Object)("Detaching from " + this.currentProcess));
                }
            } else {
                this.doStop();
            }
            this.stop = true;
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }

    protected void doStop() throws ServerError {
        Exception pException = null;
        Exception sException = null;
        if (this.currentProcess != null) {
            try {
                ProcessPrx p = ProcessPrxHelper.uncheckedCast(this.currentProcess.ice_oneway());
                p.shutdown();
                this.currentProcess = null;
            }
            catch (Exception ex) {
                log.warn((Object)"Failed to stop process", (Throwable)ex);
                pException = ex;
            }
        }
        if (this.session != null && this.session != UNINITIALIZED) {
            try {
                while (this.mgr.close(this.session.getUuid()) > 0) {
                }
                this.session = null;
            }
            catch (Exception ex) {
                log.warn((Object)("Failed to close session " + this.session.getUuid()), (Throwable)ex);
                sException = ex;
            }
        }
        if (pException != null || sException != null) {
            InternalException ie = new InternalException();
            StringBuilder sb = new StringBuilder();
            if (pException != null) {
                sb.append("Failed to shutdown process: " + pException.getMessage());
            }
            if (sException != null) {
                sb.append("Failed to close session: " + sException.getMessage());
            }
            ie.message = sb.toString();
            throw ie;
        }
    }

    private void finishedOrThrow() throws ServerError {
        if (this.currentProcess == null) {
            throw new ApiUsageException(null, null, "No current process.");
        }
        if (this.currentProcess.poll() == null) {
            throw new ApiUsageException(null, null, "Process still running.");
        }
    }

    private OriginalFile loadFileOrNull(final String name) {
        return (OriginalFile)this.ex.execute(this.principal, (Executor.Work)new Executor.SimpleWork(this, "optionallyLoadFile", new Object[0]){

            @Transactional(readOnly=true)
            public Object doWork(org.hibernate.Session session, ServiceFactory sf) {
                return sf.getQueryService().findByQuery(InteractiveProcessorI.stdfile_query, new Parameters().addId(InteractiveProcessorI.this.job.getId().getValue()).addString("name", name));
            }
        });
    }

    private void optionallyLoadFile(Map<String, RType> val, String name) {
        OriginalFile file = this.loadFileOrNull(name);
        if (file != null) {
            val.put(name, rtypes.robject(new OriginalFileI(file.getId(), false)));
        }
    }

    private void appendIfText(final OriginalFile file, final StringBuilder sb) {
        if (file.getMimetype() != null && file.getMimetype().contains("text")) {
            this.ex.execute(this.principal, (Executor.Work)new Executor.SimpleWork(this, "appendIfText", new Object[]{file}){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Transactional(readOnly=true)
                public Object doWork(org.hibernate.Session session, ServiceFactory sf) {
                    RawFileStore rfs = sf.createRawFileStore();
                    try {
                        rfs.setFileId(file.getId());
                        sb.append("\n\n---stderr---\n");
                        sb.append(new String(rfs.read(0L, file.getSize().intValue())));
                    }
                    finally {
                        rfs.close();
                    }
                    return null;
                }
            });
        }
    }

    private void failJob(final ValidationException ve) {
        this.ex.execute(this.principal, (Executor.Work)new Executor.SimpleWork(this, "failJob", new Object[]{this.job.getId().getValue()}){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Transactional(readOnly=false)
            public Object doWork(org.hibernate.Session session, ServiceFactory sf) {
                JobHandle jh = sf.createJobHandle();
                try {
                    jh.attach(InteractiveProcessorI.this.job.getId().getValue());
                    jh.setStatusAndMessage("Error", ve.message == null ? null : ve.message.substring(0, Math.min(255, ve.message.length())));
                }
                finally {
                    jh.close();
                }
                return null;
            }
        });
    }

    private Session newSession(Current __current) {
        EventContext ec = this.mgr.getEventContext(this.principal);
        Session newSession = this.mgr.createWithAgent(new Principal(ec.getCurrentUserName(), ec.getCurrentGroupName(), "Processing"), "OMERO.scripts");
        newSession.setTimeToIdle(0L);
        newSession.setTimeToLive(this.timeout);
        newSession = this.mgr.update(newSession, true);
        return newSession;
    }

    private long getScriptId(Job job) throws ValidationException {
        final Parameters p = new Parameters();
        p.addId(job.getId().getValue());
        p.addString("fmt", "text/x-python");
        OriginalFile f = (OriginalFile)this.ex.execute(this.principal, (Executor.Work)new Executor.SimpleWork(this, "getScriptId", new Object[0]){

            @Transactional(readOnly=true)
            public Object doWork(org.hibernate.Session session, ServiceFactory sf) {
                return sf.getQueryService().findByQuery(InteractiveProcessorI.this.getScriptIdQuery, p);
            }
        });
        if (f == null) {
            throw new ValidationException(null, null, "No script for job :" + job.getId().getValue());
        }
        return f.getId();
    }

    public void close(Current current) throws Exception {
        this.stop();
    }
}

