/*
 * Decompiled with CFR 0.152.
 */
package ome.util;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ome.conditions.InternalException;
import ome.model.core.Channel;
import ome.model.internal.Details;
import ome.model.stats.StatsInfo;
import ome.util.Utils;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcOperations;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface SqlAction {
    public void prepareSession(long var1, long var3, long var5);

    public boolean activeSession(String var1);

    public String fileRepo(long var1);

    public String scriptRepo(long var1);

    public int synchronizeJobs(List<Long> var1);

    public Long findRepoFile(String var1, String var2, String var3, String var4);

    public String findRepoFilePath(String var1, long var2);

    public List<Long> findRepoPixels(String var1, String var2, String var3);

    public Long findRepoImageFromPixels(long var1);

    public int repoScriptCount(String var1);

    public Long nextSessionId();

    public List<Long> fileIdsInDb(String var1);

    public Map<String, Object> repoFile(long var1);

    public List<long[]> nextPixelsDataLogForRepo(String var1, long var2);

    public long countFormat(String var1);

    public int insertFormat(String var1);

    public int closeSessions(String var1);

    public int closeNodeSessions(String var1);

    public int closeNode(String var1);

    public long nodeId(String var1);

    public int insertSession(Map<String, Object> var1);

    public Long sessionId(String var1);

    public int isFileInRepo(String var1, long var2);

    public int removePassword(Long var1);

    public Date now();

    public int updateConfiguration(String var1, String var2);

    public String dbVersion();

    public String configValue(String var1);

    public String dbUuid();

    public long selectCurrentEventLog(String var1);

    public void setCurrentEventLog(long var1, String var3);

    public void delCurrentEventLog(String var1);

    public long nextValue(String var1, int var2);

    public long currValue(String var1);

    public void insertLogs(List<Object[]> var1);

    public List<Map<String, Object>> roiByImageAndNs(long var1, String var3);

    public List<Long> getShapeIds(long var1);

    public String dnForUser(Long var1);

    public List<Map<String, Object>> dnExperimenterMaps();

    public void setUserDn(Long var1, String var2);

    public boolean setUserPassword(Long var1, String var2);

    public String getPasswordHash(Long var1);

    public Long getUserId(String var1);

    public List<String> getUserGroups(String var1);

    public void setFileRepo(long var1, String var3);

    public void setPixelsNamePathRepo(long var1, String var3, String var4, String var5);

    public long setStatsInfo(Channel var1, StatsInfo var2);

    public List<Long> getDeletedIds(String var1);

    public void createSavepoint(String var1);

    public void releaseSavepoint(String var1);

    public void rollbackSavepoint(String var1);

    public void deferConstraints();

    public List<String> getPixelsParamKeys(long var1) throws InternalException;

    public Map<String, String> getPixelsParams(long var1) throws InternalException;

    public List<String> getPixelsNamePathRepo(long var1) throws InternalException;

    public int setPixelsParams(long var1, Map<String, String> var3);

    public int setPixelsParam(long var1, String var3, String var4);

    public List<String> getFileParamKeys(long var1) throws InternalException;

    public Map<String, String> getFileParams(long var1) throws InternalException;

    public int setFileParams(long var1, Map<String, String> var3);

    public int setFileParam(long var1, String var3, String var4);

    public Set<String> currentUserNames();

    public int changeGroupPermissions(Long var1, Long var2);

    public int changeTablePermissionsForGroup(String var1, Long var2, Long var3);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Impl
    implements SqlAction {
        protected abstract SimpleJdbcOperations _jdbc();

        protected abstract String _lookup(String var1);

        @Override
        public int closeNodeSessions(String uuid) {
            return this._jdbc().update(this._lookup("update_node_sessions"), uuid);
        }

        @Override
        public int closeNode(String uuid) {
            return this._jdbc().update(this._lookup("update_node"), uuid);
        }

        @Override
        public boolean setUserPassword(Long experimenterID, String password) {
            int results = this._jdbc().update(this._lookup("update_password"), password, experimenterID);
            if (results < 1) {
                results = this._jdbc().update(this._lookup("insert_password"), experimenterID, password, null);
            }
            return results >= 1;
        }

        @Override
        public int changeGroupPermissions(Long id, Long internal) {
            return this._jdbc().update(this._lookup("update_permissions_for_group"), internal, id);
        }

        @Override
        public int changeTablePermissionsForGroup(String table, Long id, Long internal) {
            String sql = this._lookup("update_permissions_for_table");
            sql = String.format(sql, table);
            return this._jdbc().update(sql, internal, id);
        }

        @Override
        public List<long[]> nextPixelsDataLogForRepo(String repo, long lastEventId) {
            RowMapper<long[]> rm = new RowMapper<long[]>(){

                @Override
                public long[] mapRow(ResultSet arg0, int arg1) throws SQLException {
                    long[] rv = new long[]{arg0.getLong(1), arg0.getLong(2), arg0.getLong(3)};
                    return rv;
                }
            };
            try {
                if (repo == null) {
                    return this._jdbc().query(this._lookup("find_next_pixels_data_per_user_for_null_repo"), rm, lastEventId);
                }
                return this._jdbc().query(this._lookup("find_next_pixels_data__per_user_for_repo"), rm, lastEventId, repo);
            }
            catch (EmptyResultDataAccessException erdae) {
                return null;
            }
        }

        @Override
        public String fileRepo(long fileId) {
            return this._jdbc().queryForObject(this._lookup("file_repo"), String.class, fileId);
        }

        @Override
        public String scriptRepo(long fileId) {
            try {
                return this._jdbc().queryForObject(this._lookup("file_repo_of_script"), String.class, fileId);
            }
            catch (EmptyResultDataAccessException erdae) {
                return null;
            }
        }

        @Override
        public long setStatsInfo(Channel ch, StatsInfo si) {
            Details d = ch.getDetails();
            long id = this.nextValue("seq_statsinfo", 1);
            this._jdbc().update(this._lookup("stats_info_creation"), id, Utils.internalForm(d.getPermissions()), si.getGlobalMax(), si.getGlobalMin(), d.getCreationEvent().getId(), d.getGroup().getId(), d.getOwner().getId(), d.getUpdateEvent().getId());
            this._jdbc().update(this._lookup("stats_info_set_on_channel"), id, ch.getId());
            return id;
        }

        @Override
        public String configValue(String key) {
            try {
                return this._jdbc().queryForObject(this._lookup("config_value"), String.class, key);
            }
            catch (EmptyResultDataAccessException erdae) {
                return null;
            }
        }

        @Override
        public long selectCurrentEventLog(String key) {
            String value = this._jdbc().queryForObject(this._lookup("log_loader_query"), String.class, key);
            return Long.valueOf(value);
        }

        @Override
        public void setCurrentEventLog(long id, String key) {
            int count = this._jdbc().update(this._lookup("log_loader_update"), Long.toString(id), key);
            if (count == 0) {
                this._jdbc().update(this._lookup("log_loader_insert"), key, Long.toString(id));
            }
        }

        @Override
        public void delCurrentEventLog(String key) {
            this._jdbc().update(this._lookup("log_loader_delete"), key);
        }

        @Override
        public String dnForUser(Long id) {
            String dn;
            try {
                dn = this._jdbc().queryForObject(this._lookup("dn_for_user"), String.class, id);
            }
            catch (EmptyResultDataAccessException e) {
                dn = null;
            }
            if (dn == null || dn.trim().length() == 0) {
                return null;
            }
            return dn;
        }

        @Override
        public List<Map<String, Object>> dnExperimenterMaps() {
            List<Map<String, Object>> maps = this._jdbc().queryForList(this._lookup("dn_exp_maps"), new Object[0]);
            ArrayList<Map<String, Object>> copy = new ArrayList<Map<String, Object>>();
            for (Map<String, Object> map : maps) {
                if (map.keySet().iterator().next().trim().length() <= 0) continue;
                copy.add(map);
            }
            return copy;
        }

        @Override
        public void setUserDn(Long experimenterID, String dn) {
            int results;
            if (dn != null && dn.trim().length() == 0) {
                dn = null;
            }
            if ((results = this._jdbc().update(this._lookup("set_user_dn"), dn, experimenterID)) < 1) {
                results = this._jdbc().update(this._lookup("insert_password"), experimenterID, null, dn);
            }
        }
    }

    public static class LoggingSqlAction
    implements MethodInterceptor {
        private static final Log log = LogFactory.getLog(SqlAction.class);

        public Object invoke(MethodInvocation arg0) throws Throwable {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("%s.%s(%s)", arg0.getThis(), arg0.getMethod().getName(), Arrays.deepToString(arg0.getArguments())));
            }
            return arg0.proceed();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class IdRowMapper
    implements RowMapper<Long> {
        @Override
        public Long mapRow(ResultSet rs, int rowNum) throws SQLException {
            return rs.getLong(1);
        }
    }
}

